/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An inferred source configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedS3SourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectedS3SourceConfig.Builder, DetectedS3SourceConfig> {
    private static final SdkField<DetectedFileFormatDescriptor> FILE_FORMAT_DESCRIPTOR_FIELD = SdkField
            .<DetectedFileFormatDescriptor> builder(MarshallingType.SDK_POJO).memberName("FileFormatDescriptor")
            .getter(getter(DetectedS3SourceConfig::fileFormatDescriptor)).setter(setter(Builder::fileFormatDescriptor))
            .constructor(DetectedFileFormatDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormatDescriptor").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FORMAT_DESCRIPTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final DetectedFileFormatDescriptor fileFormatDescriptor;

    private DetectedS3SourceConfig(BuilderImpl builder) {
        this.fileFormatDescriptor = builder.fileFormatDescriptor;
    }

    /**
     * <p>
     * The source's file format descriptor.
     * </p>
     * 
     * @return The source's file format descriptor.
     */
    public final DetectedFileFormatDescriptor fileFormatDescriptor() {
        return fileFormatDescriptor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatDescriptor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedS3SourceConfig)) {
            return false;
        }
        DetectedS3SourceConfig other = (DetectedS3SourceConfig) obj;
        return Objects.equals(fileFormatDescriptor(), other.fileFormatDescriptor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectedS3SourceConfig").add("FileFormatDescriptor", fileFormatDescriptor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileFormatDescriptor":
            return Optional.ofNullable(clazz.cast(fileFormatDescriptor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectedS3SourceConfig, T> g) {
        return obj -> g.apply((DetectedS3SourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedS3SourceConfig> {
        /**
         * <p>
         * The source's file format descriptor.
         * </p>
         * 
         * @param fileFormatDescriptor
         *        The source's file format descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFormatDescriptor(DetectedFileFormatDescriptor fileFormatDescriptor);

        /**
         * <p>
         * The source's file format descriptor.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedFileFormatDescriptor.Builder}
         * avoiding the need to create one manually via {@link DetectedFileFormatDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedFileFormatDescriptor.Builder#build()} is called
         * immediately and its result is passed to {@link #fileFormatDescriptor(DetectedFileFormatDescriptor)}.
         * 
         * @param fileFormatDescriptor
         *        a consumer that will call methods on {@link DetectedFileFormatDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileFormatDescriptor(DetectedFileFormatDescriptor)
         */
        default Builder fileFormatDescriptor(Consumer<DetectedFileFormatDescriptor.Builder> fileFormatDescriptor) {
            return fileFormatDescriptor(DetectedFileFormatDescriptor.builder().applyMutation(fileFormatDescriptor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DetectedFileFormatDescriptor fileFormatDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedS3SourceConfig model) {
            fileFormatDescriptor(model.fileFormatDescriptor);
        }

        public final DetectedFileFormatDescriptor.Builder getFileFormatDescriptor() {
            return fileFormatDescriptor != null ? fileFormatDescriptor.toBuilder() : null;
        }

        public final void setFileFormatDescriptor(DetectedFileFormatDescriptor.BuilderImpl fileFormatDescriptor) {
            this.fileFormatDescriptor = fileFormatDescriptor != null ? fileFormatDescriptor.build() : null;
        }

        @Override
        public final Builder fileFormatDescriptor(DetectedFileFormatDescriptor fileFormatDescriptor) {
            this.fileFormatDescriptor = fileFormatDescriptor;
            return this;
        }

        @Override
        public DetectedS3SourceConfig build() {
            return new DetectedS3SourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
