/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A detected JSON format descriptor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedJsonFormatDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectedJsonFormatDescriptor.Builder, DetectedJsonFormatDescriptor> {
    private static final SdkField<DetectedField> FILE_COMPRESSION_FIELD = SdkField
            .<DetectedField> builder(MarshallingType.SDK_POJO).memberName("FileCompression")
            .getter(getter(DetectedJsonFormatDescriptor::fileCompression)).setter(setter(Builder::fileCompression))
            .constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCompression").build()).build();

    private static final SdkField<DetectedField> CHARSET_FIELD = SdkField.<DetectedField> builder(MarshallingType.SDK_POJO)
            .memberName("Charset").getter(getter(DetectedJsonFormatDescriptor::charset)).setter(setter(Builder::charset))
            .constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Charset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_COMPRESSION_FIELD,
            CHARSET_FIELD));

    private static final long serialVersionUID = 1L;

    private final DetectedField fileCompression;

    private final DetectedField charset;

    private DetectedJsonFormatDescriptor(BuilderImpl builder) {
        this.fileCompression = builder.fileCompression;
        this.charset = builder.charset;
    }

    /**
     * <p>
     * The format's file compression.
     * </p>
     * 
     * @return The format's file compression.
     */
    public final DetectedField fileCompression() {
        return fileCompression;
    }

    /**
     * <p>
     * The format's character set.
     * </p>
     * 
     * @return The format's character set.
     */
    public final DetectedField charset() {
        return charset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileCompression());
        hashCode = 31 * hashCode + Objects.hashCode(charset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedJsonFormatDescriptor)) {
            return false;
        }
        DetectedJsonFormatDescriptor other = (DetectedJsonFormatDescriptor) obj;
        return Objects.equals(fileCompression(), other.fileCompression()) && Objects.equals(charset(), other.charset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectedJsonFormatDescriptor").add("FileCompression", fileCompression())
                .add("Charset", charset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileCompression":
            return Optional.ofNullable(clazz.cast(fileCompression()));
        case "Charset":
            return Optional.ofNullable(clazz.cast(charset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectedJsonFormatDescriptor, T> g) {
        return obj -> g.apply((DetectedJsonFormatDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedJsonFormatDescriptor> {
        /**
         * <p>
         * The format's file compression.
         * </p>
         * 
         * @param fileCompression
         *        The format's file compression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileCompression(DetectedField fileCompression);

        /**
         * <p>
         * The format's file compression.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #fileCompression(DetectedField)}.
         * 
         * @param fileCompression
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileCompression(DetectedField)
         */
        default Builder fileCompression(Consumer<DetectedField.Builder> fileCompression) {
            return fileCompression(DetectedField.builder().applyMutation(fileCompression).build());
        }

        /**
         * <p>
         * The format's character set.
         * </p>
         * 
         * @param charset
         *        The format's character set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder charset(DetectedField charset);

        /**
         * <p>
         * The format's character set.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #charset(DetectedField)}.
         * 
         * @param charset
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #charset(DetectedField)
         */
        default Builder charset(Consumer<DetectedField.Builder> charset) {
            return charset(DetectedField.builder().applyMutation(charset).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DetectedField fileCompression;

        private DetectedField charset;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedJsonFormatDescriptor model) {
            fileCompression(model.fileCompression);
            charset(model.charset);
        }

        public final DetectedField.Builder getFileCompression() {
            return fileCompression != null ? fileCompression.toBuilder() : null;
        }

        public final void setFileCompression(DetectedField.BuilderImpl fileCompression) {
            this.fileCompression = fileCompression != null ? fileCompression.build() : null;
        }

        @Override
        public final Builder fileCompression(DetectedField fileCompression) {
            this.fileCompression = fileCompression;
            return this;
        }

        public final DetectedField.Builder getCharset() {
            return charset != null ? charset.toBuilder() : null;
        }

        public final void setCharset(DetectedField.BuilderImpl charset) {
            this.charset = charset != null ? charset.build() : null;
        }

        @Override
        public final Builder charset(DetectedField charset) {
            this.charset = charset;
            return this;
        }

        @Override
        public DetectedJsonFormatDescriptor build() {
            return new DetectedJsonFormatDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
