/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of an inferred CSV format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedCsvFormatDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectedCsvFormatDescriptor.Builder, DetectedCsvFormatDescriptor> {
    private static final SdkField<DetectedField> FILE_COMPRESSION_FIELD = SdkField
            .<DetectedField> builder(MarshallingType.SDK_POJO).memberName("FileCompression")
            .getter(getter(DetectedCsvFormatDescriptor::fileCompression)).setter(setter(Builder::fileCompression))
            .constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCompression").build()).build();

    private static final SdkField<DetectedField> CHARSET_FIELD = SdkField.<DetectedField> builder(MarshallingType.SDK_POJO)
            .memberName("Charset").getter(getter(DetectedCsvFormatDescriptor::charset)).setter(setter(Builder::charset))
            .constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Charset").build()).build();

    private static final SdkField<DetectedField> CONTAINS_HEADER_FIELD = SdkField
            .<DetectedField> builder(MarshallingType.SDK_POJO).memberName("ContainsHeader")
            .getter(getter(DetectedCsvFormatDescriptor::containsHeader)).setter(setter(Builder::containsHeader))
            .constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsHeader").build()).build();

    private static final SdkField<DetectedField> DELIMITER_FIELD = SdkField.<DetectedField> builder(MarshallingType.SDK_POJO)
            .memberName("Delimiter").getter(getter(DetectedCsvFormatDescriptor::delimiter)).setter(setter(Builder::delimiter))
            .constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()).build();

    private static final SdkField<DetectedField> HEADER_LIST_FIELD = SdkField.<DetectedField> builder(MarshallingType.SDK_POJO)
            .memberName("HeaderList").getter(getter(DetectedCsvFormatDescriptor::headerList)).setter(setter(Builder::headerList))
            .constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderList").build()).build();

    private static final SdkField<DetectedField> QUOTE_SYMBOL_FIELD = SdkField.<DetectedField> builder(MarshallingType.SDK_POJO)
            .memberName("QuoteSymbol").getter(getter(DetectedCsvFormatDescriptor::quoteSymbol))
            .setter(setter(Builder::quoteSymbol)).constructor(DetectedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteSymbol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_COMPRESSION_FIELD,
            CHARSET_FIELD, CONTAINS_HEADER_FIELD, DELIMITER_FIELD, HEADER_LIST_FIELD, QUOTE_SYMBOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final DetectedField fileCompression;

    private final DetectedField charset;

    private final DetectedField containsHeader;

    private final DetectedField delimiter;

    private final DetectedField headerList;

    private final DetectedField quoteSymbol;

    private DetectedCsvFormatDescriptor(BuilderImpl builder) {
        this.fileCompression = builder.fileCompression;
        this.charset = builder.charset;
        this.containsHeader = builder.containsHeader;
        this.delimiter = builder.delimiter;
        this.headerList = builder.headerList;
        this.quoteSymbol = builder.quoteSymbol;
    }

    /**
     * <p>
     * The format's file compression.
     * </p>
     * 
     * @return The format's file compression.
     */
    public final DetectedField fileCompression() {
        return fileCompression;
    }

    /**
     * <p>
     * The format's charset.
     * </p>
     * 
     * @return The format's charset.
     */
    public final DetectedField charset() {
        return charset;
    }

    /**
     * <p>
     * Whether the format includes a header.
     * </p>
     * 
     * @return Whether the format includes a header.
     */
    public final DetectedField containsHeader() {
        return containsHeader;
    }

    /**
     * <p>
     * The format's delimiter.
     * </p>
     * 
     * @return The format's delimiter.
     */
    public final DetectedField delimiter() {
        return delimiter;
    }

    /**
     * <p>
     * The format's header list.
     * </p>
     * 
     * @return The format's header list.
     */
    public final DetectedField headerList() {
        return headerList;
    }

    /**
     * <p>
     * The format's quote symbol.
     * </p>
     * 
     * @return The format's quote symbol.
     */
    public final DetectedField quoteSymbol() {
        return quoteSymbol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileCompression());
        hashCode = 31 * hashCode + Objects.hashCode(charset());
        hashCode = 31 * hashCode + Objects.hashCode(containsHeader());
        hashCode = 31 * hashCode + Objects.hashCode(delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(headerList());
        hashCode = 31 * hashCode + Objects.hashCode(quoteSymbol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedCsvFormatDescriptor)) {
            return false;
        }
        DetectedCsvFormatDescriptor other = (DetectedCsvFormatDescriptor) obj;
        return Objects.equals(fileCompression(), other.fileCompression()) && Objects.equals(charset(), other.charset())
                && Objects.equals(containsHeader(), other.containsHeader()) && Objects.equals(delimiter(), other.delimiter())
                && Objects.equals(headerList(), other.headerList()) && Objects.equals(quoteSymbol(), other.quoteSymbol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectedCsvFormatDescriptor").add("FileCompression", fileCompression())
                .add("Charset", charset()).add("ContainsHeader", containsHeader()).add("Delimiter", delimiter())
                .add("HeaderList", headerList()).add("QuoteSymbol", quoteSymbol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileCompression":
            return Optional.ofNullable(clazz.cast(fileCompression()));
        case "Charset":
            return Optional.ofNullable(clazz.cast(charset()));
        case "ContainsHeader":
            return Optional.ofNullable(clazz.cast(containsHeader()));
        case "Delimiter":
            return Optional.ofNullable(clazz.cast(delimiter()));
        case "HeaderList":
            return Optional.ofNullable(clazz.cast(headerList()));
        case "QuoteSymbol":
            return Optional.ofNullable(clazz.cast(quoteSymbol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectedCsvFormatDescriptor, T> g) {
        return obj -> g.apply((DetectedCsvFormatDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedCsvFormatDescriptor> {
        /**
         * <p>
         * The format's file compression.
         * </p>
         * 
         * @param fileCompression
         *        The format's file compression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileCompression(DetectedField fileCompression);

        /**
         * <p>
         * The format's file compression.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #fileCompression(DetectedField)}.
         * 
         * @param fileCompression
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileCompression(DetectedField)
         */
        default Builder fileCompression(Consumer<DetectedField.Builder> fileCompression) {
            return fileCompression(DetectedField.builder().applyMutation(fileCompression).build());
        }

        /**
         * <p>
         * The format's charset.
         * </p>
         * 
         * @param charset
         *        The format's charset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder charset(DetectedField charset);

        /**
         * <p>
         * The format's charset.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #charset(DetectedField)}.
         * 
         * @param charset
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #charset(DetectedField)
         */
        default Builder charset(Consumer<DetectedField.Builder> charset) {
            return charset(DetectedField.builder().applyMutation(charset).build());
        }

        /**
         * <p>
         * Whether the format includes a header.
         * </p>
         * 
         * @param containsHeader
         *        Whether the format includes a header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsHeader(DetectedField containsHeader);

        /**
         * <p>
         * Whether the format includes a header.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #containsHeader(DetectedField)}.
         * 
         * @param containsHeader
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containsHeader(DetectedField)
         */
        default Builder containsHeader(Consumer<DetectedField.Builder> containsHeader) {
            return containsHeader(DetectedField.builder().applyMutation(containsHeader).build());
        }

        /**
         * <p>
         * The format's delimiter.
         * </p>
         * 
         * @param delimiter
         *        The format's delimiter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(DetectedField delimiter);

        /**
         * <p>
         * The format's delimiter.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #delimiter(DetectedField)}.
         * 
         * @param delimiter
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delimiter(DetectedField)
         */
        default Builder delimiter(Consumer<DetectedField.Builder> delimiter) {
            return delimiter(DetectedField.builder().applyMutation(delimiter).build());
        }

        /**
         * <p>
         * The format's header list.
         * </p>
         * 
         * @param headerList
         *        The format's header list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerList(DetectedField headerList);

        /**
         * <p>
         * The format's header list.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #headerList(DetectedField)}.
         * 
         * @param headerList
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headerList(DetectedField)
         */
        default Builder headerList(Consumer<DetectedField.Builder> headerList) {
            return headerList(DetectedField.builder().applyMutation(headerList).build());
        }

        /**
         * <p>
         * The format's quote symbol.
         * </p>
         * 
         * @param quoteSymbol
         *        The format's quote symbol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quoteSymbol(DetectedField quoteSymbol);

        /**
         * <p>
         * The format's quote symbol.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectedField.Builder} avoiding the need
         * to create one manually via {@link DetectedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectedField.Builder#build()} is called immediately and its
         * result is passed to {@link #quoteSymbol(DetectedField)}.
         * 
         * @param quoteSymbol
         *        a consumer that will call methods on {@link DetectedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quoteSymbol(DetectedField)
         */
        default Builder quoteSymbol(Consumer<DetectedField.Builder> quoteSymbol) {
            return quoteSymbol(DetectedField.builder().applyMutation(quoteSymbol).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DetectedField fileCompression;

        private DetectedField charset;

        private DetectedField containsHeader;

        private DetectedField delimiter;

        private DetectedField headerList;

        private DetectedField quoteSymbol;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedCsvFormatDescriptor model) {
            fileCompression(model.fileCompression);
            charset(model.charset);
            containsHeader(model.containsHeader);
            delimiter(model.delimiter);
            headerList(model.headerList);
            quoteSymbol(model.quoteSymbol);
        }

        public final DetectedField.Builder getFileCompression() {
            return fileCompression != null ? fileCompression.toBuilder() : null;
        }

        public final void setFileCompression(DetectedField.BuilderImpl fileCompression) {
            this.fileCompression = fileCompression != null ? fileCompression.build() : null;
        }

        @Override
        public final Builder fileCompression(DetectedField fileCompression) {
            this.fileCompression = fileCompression;
            return this;
        }

        public final DetectedField.Builder getCharset() {
            return charset != null ? charset.toBuilder() : null;
        }

        public final void setCharset(DetectedField.BuilderImpl charset) {
            this.charset = charset != null ? charset.build() : null;
        }

        @Override
        public final Builder charset(DetectedField charset) {
            this.charset = charset;
            return this;
        }

        public final DetectedField.Builder getContainsHeader() {
            return containsHeader != null ? containsHeader.toBuilder() : null;
        }

        public final void setContainsHeader(DetectedField.BuilderImpl containsHeader) {
            this.containsHeader = containsHeader != null ? containsHeader.build() : null;
        }

        @Override
        public final Builder containsHeader(DetectedField containsHeader) {
            this.containsHeader = containsHeader;
            return this;
        }

        public final DetectedField.Builder getDelimiter() {
            return delimiter != null ? delimiter.toBuilder() : null;
        }

        public final void setDelimiter(DetectedField.BuilderImpl delimiter) {
            this.delimiter = delimiter != null ? delimiter.build() : null;
        }

        @Override
        public final Builder delimiter(DetectedField delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final DetectedField.Builder getHeaderList() {
            return headerList != null ? headerList.toBuilder() : null;
        }

        public final void setHeaderList(DetectedField.BuilderImpl headerList) {
            this.headerList = headerList != null ? headerList.build() : null;
        }

        @Override
        public final Builder headerList(DetectedField headerList) {
            this.headerList = headerList;
            return this;
        }

        public final DetectedField.Builder getQuoteSymbol() {
            return quoteSymbol != null ? quoteSymbol.toBuilder() : null;
        }

        public final void setQuoteSymbol(DetectedField.BuilderImpl quoteSymbol) {
            this.quoteSymbol = quoteSymbol != null ? quoteSymbol.build() : null;
        }

        @Override
        public final Builder quoteSymbol(DetectedField quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
            return this;
        }

        @Override
        public DetectedCsvFormatDescriptor build() {
            return new DetectedCsvFormatDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
