/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of an Amazon Lightsail bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketState implements SdkPojo, Serializable, ToCopyableBuilder<BucketState.Builder, BucketState> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(BucketState::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BucketState::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private BucketState(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The state code of the bucket.
     * </p>
     * <p>
     * The following codes are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OK</code> - The bucket is in a running state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unknown</code> - Creation of the bucket might have timed-out. You might want to delete the bucket and
     * create a new one.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The state code of the bucket.</p>
     *         <p>
     *         The following codes are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OK</code> - The bucket is in a running state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unknown</code> - Creation of the bucket might have timed-out. You might want to delete the bucket
     *         and create a new one.
     *         </p>
     *         </li>
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * A message that describes the state of the bucket.
     * </p>
     * 
     * @return A message that describes the state of the bucket.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketState)) {
            return false;
        }
        BucketState other = (BucketState) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketState").add("Code", code()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketState, T> g) {
        return obj -> g.apply((BucketState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketState> {
        /**
         * <p>
         * The state code of the bucket.
         * </p>
         * <p>
         * The following codes are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OK</code> - The bucket is in a running state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unknown</code> - Creation of the bucket might have timed-out. You might want to delete the bucket and
         * create a new one.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The state code of the bucket.</p>
         *        <p>
         *        The following codes are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OK</code> - The bucket is in a running state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unknown</code> - Creation of the bucket might have timed-out. You might want to delete the
         *        bucket and create a new one.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A message that describes the state of the bucket.
         * </p>
         * 
         * @param message
         *        A message that describes the state of the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketState model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BucketState build() {
            return new BucketState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
