/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerServiceStateDetailCode {
    CREATING_SYSTEM_RESOURCES("CREATING_SYSTEM_RESOURCES"),
    CREATING_NETWORK_INFRASTRUCTURE("CREATING_NETWORK_INFRASTRUCTURE"),
    PROVISIONING_CERTIFICATE("PROVISIONING_CERTIFICATE"),
    PROVISIONING_SERVICE("PROVISIONING_SERVICE"),
    CREATING_DEPLOYMENT("CREATING_DEPLOYMENT"),
    EVALUATING_HEALTH_CHECK("EVALUATING_HEALTH_CHECK"),
    ACTIVATING_DEPLOYMENT("ACTIVATING_DEPLOYMENT"),
    CERTIFICATE_LIMIT_EXCEEDED("CERTIFICATE_LIMIT_EXCEEDED"),
    UNKNOWN_ERROR("UNKNOWN_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerServiceStateDetailCode> VALUE_MAP;
    private final String value;

    private ContainerServiceStateDetailCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerServiceStateDetailCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerServiceStateDetailCode> knownValues() {
        EnumSet<ContainerServiceStateDetailCode> knownValues = EnumSet.allOf(ContainerServiceStateDetailCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerServiceStateDetailCode.class, ContainerServiceStateDetailCode::toString);
    }
}

