/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PortState {
    OPEN("open"),
    CLOSED("closed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PortState> VALUE_MAP;
    private final String value;

    private PortState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PortState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PortState> knownValues() {
        EnumSet<PortState> knownValues = EnumSet.allOf(PortState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PortState.class, PortState::toString);
    }
}

