/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationType {
    DELETE_KNOWN_HOST_KEYS("DeleteKnownHostKeys"),
    DELETE_INSTANCE("DeleteInstance"),
    CREATE_INSTANCE("CreateInstance"),
    STOP_INSTANCE("StopInstance"),
    START_INSTANCE("StartInstance"),
    REBOOT_INSTANCE("RebootInstance"),
    OPEN_INSTANCE_PUBLIC_PORTS("OpenInstancePublicPorts"),
    PUT_INSTANCE_PUBLIC_PORTS("PutInstancePublicPorts"),
    CLOSE_INSTANCE_PUBLIC_PORTS("CloseInstancePublicPorts"),
    ALLOCATE_STATIC_IP("AllocateStaticIp"),
    RELEASE_STATIC_IP("ReleaseStaticIp"),
    ATTACH_STATIC_IP("AttachStaticIp"),
    DETACH_STATIC_IP("DetachStaticIp"),
    UPDATE_DOMAIN_ENTRY("UpdateDomainEntry"),
    DELETE_DOMAIN_ENTRY("DeleteDomainEntry"),
    CREATE_DOMAIN("CreateDomain"),
    DELETE_DOMAIN("DeleteDomain"),
    CREATE_INSTANCE_SNAPSHOT("CreateInstanceSnapshot"),
    DELETE_INSTANCE_SNAPSHOT("DeleteInstanceSnapshot"),
    CREATE_INSTANCES_FROM_SNAPSHOT("CreateInstancesFromSnapshot"),
    CREATE_LOAD_BALANCER("CreateLoadBalancer"),
    DELETE_LOAD_BALANCER("DeleteLoadBalancer"),
    ATTACH_INSTANCES_TO_LOAD_BALANCER("AttachInstancesToLoadBalancer"),
    DETACH_INSTANCES_FROM_LOAD_BALANCER("DetachInstancesFromLoadBalancer"),
    UPDATE_LOAD_BALANCER_ATTRIBUTE("UpdateLoadBalancerAttribute"),
    CREATE_LOAD_BALANCER_TLS_CERTIFICATE("CreateLoadBalancerTlsCertificate"),
    DELETE_LOAD_BALANCER_TLS_CERTIFICATE("DeleteLoadBalancerTlsCertificate"),
    ATTACH_LOAD_BALANCER_TLS_CERTIFICATE("AttachLoadBalancerTlsCertificate"),
    CREATE_DISK("CreateDisk"),
    DELETE_DISK("DeleteDisk"),
    ATTACH_DISK("AttachDisk"),
    DETACH_DISK("DetachDisk"),
    CREATE_DISK_SNAPSHOT("CreateDiskSnapshot"),
    DELETE_DISK_SNAPSHOT("DeleteDiskSnapshot"),
    CREATE_DISK_FROM_SNAPSHOT("CreateDiskFromSnapshot"),
    CREATE_RELATIONAL_DATABASE("CreateRelationalDatabase"),
    UPDATE_RELATIONAL_DATABASE("UpdateRelationalDatabase"),
    DELETE_RELATIONAL_DATABASE("DeleteRelationalDatabase"),
    CREATE_RELATIONAL_DATABASE_FROM_SNAPSHOT("CreateRelationalDatabaseFromSnapshot"),
    CREATE_RELATIONAL_DATABASE_SNAPSHOT("CreateRelationalDatabaseSnapshot"),
    DELETE_RELATIONAL_DATABASE_SNAPSHOT("DeleteRelationalDatabaseSnapshot"),
    UPDATE_RELATIONAL_DATABASE_PARAMETERS("UpdateRelationalDatabaseParameters"),
    START_RELATIONAL_DATABASE("StartRelationalDatabase"),
    REBOOT_RELATIONAL_DATABASE("RebootRelationalDatabase"),
    STOP_RELATIONAL_DATABASE("StopRelationalDatabase"),
    ENABLE_ADD_ON("EnableAddOn"),
    DISABLE_ADD_ON("DisableAddOn"),
    PUT_ALARM("PutAlarm"),
    GET_ALARMS("GetAlarms"),
    DELETE_ALARM("DeleteAlarm"),
    TEST_ALARM("TestAlarm"),
    CREATE_CONTACT_METHOD("CreateContactMethod"),
    GET_CONTACT_METHODS("GetContactMethods"),
    SEND_CONTACT_METHOD_VERIFICATION("SendContactMethodVerification"),
    DELETE_CONTACT_METHOD("DeleteContactMethod"),
    CREATE_DISTRIBUTION("CreateDistribution"),
    UPDATE_DISTRIBUTION("UpdateDistribution"),
    DELETE_DISTRIBUTION("DeleteDistribution"),
    RESET_DISTRIBUTION_CACHE("ResetDistributionCache"),
    ATTACH_CERTIFICATE_TO_DISTRIBUTION("AttachCertificateToDistribution"),
    DETACH_CERTIFICATE_FROM_DISTRIBUTION("DetachCertificateFromDistribution"),
    UPDATE_DISTRIBUTION_BUNDLE("UpdateDistributionBundle"),
    SET_IP_ADDRESS_TYPE("SetIpAddressType"),
    CREATE_CERTIFICATE("CreateCertificate"),
    DELETE_CERTIFICATE("DeleteCertificate"),
    CREATE_CONTAINER_SERVICE("CreateContainerService"),
    UPDATE_CONTAINER_SERVICE("UpdateContainerService"),
    DELETE_CONTAINER_SERVICE("DeleteContainerService"),
    CREATE_CONTAINER_SERVICE_DEPLOYMENT("CreateContainerServiceDeployment"),
    CREATE_CONTAINER_SERVICE_REGISTRY_LOGIN("CreateContainerServiceRegistryLogin"),
    REGISTER_CONTAINER_IMAGE("RegisterContainerImage"),
    DELETE_CONTAINER_IMAGE("DeleteContainerImage"),
    CREATE_BUCKET("CreateBucket"),
    DELETE_BUCKET("DeleteBucket"),
    CREATE_BUCKET_ACCESS_KEY("CreateBucketAccessKey"),
    DELETE_BUCKET_ACCESS_KEY("DeleteBucketAccessKey"),
    UPDATE_BUCKET_BUNDLE("UpdateBucketBundle"),
    UPDATE_BUCKET("UpdateBucket"),
    SET_RESOURCE_ACCESS_FOR_BUCKET("SetResourceAccessForBucket"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationType> VALUE_MAP;
    private final String value;

    private OperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationType> knownValues() {
        EnumSet<OperationType> knownValues = EnumSet.allOf(OperationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationType.class, OperationType::toString);
    }
}

