/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists the settings defined for discovering Linux subscriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinuxSubscriptionsDiscoverySettings implements SdkPojo, Serializable,
        ToCopyableBuilder<LinuxSubscriptionsDiscoverySettings.Builder, LinuxSubscriptionsDiscoverySettings> {
    private static final SdkField<String> ORGANIZATION_INTEGRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationIntegration")
            .getter(getter(LinuxSubscriptionsDiscoverySettings::organizationIntegrationAsString))
            .setter(setter(Builder::organizationIntegration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationIntegration").build())
            .build();

    private static final SdkField<List<String>> SOURCE_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceRegions")
            .getter(getter(LinuxSubscriptionsDiscoverySettings::sourceRegions))
            .setter(setter(Builder::sourceRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_INTEGRATION_FIELD, SOURCE_REGIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationIntegration;

    private final List<String> sourceRegions;

    private LinuxSubscriptionsDiscoverySettings(BuilderImpl builder) {
        this.organizationIntegration = builder.organizationIntegration;
        this.sourceRegions = builder.sourceRegions;
    }

    /**
     * <p>
     * Details if you have enabled resource discovery across your accounts in Organizations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationIntegration} will return {@link OrganizationIntegration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #organizationIntegrationAsString}.
     * </p>
     * 
     * @return Details if you have enabled resource discovery across your accounts in Organizations.
     * @see OrganizationIntegration
     */
    public final OrganizationIntegration organizationIntegration() {
        return OrganizationIntegration.fromValue(organizationIntegration);
    }

    /**
     * <p>
     * Details if you have enabled resource discovery across your accounts in Organizations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationIntegration} will return {@link OrganizationIntegration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #organizationIntegrationAsString}.
     * </p>
     * 
     * @return Details if you have enabled resource discovery across your accounts in Organizations.
     * @see OrganizationIntegration
     */
    public final String organizationIntegrationAsString() {
        return organizationIntegration;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceRegions() {
        return sourceRegions != null && !(sourceRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Regions in which to discover data for Linux subscriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceRegions} method.
     * </p>
     * 
     * @return The Regions in which to discover data for Linux subscriptions.
     */
    public final List<String> sourceRegions() {
        return sourceRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationIntegrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceRegions() ? sourceRegions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinuxSubscriptionsDiscoverySettings)) {
            return false;
        }
        LinuxSubscriptionsDiscoverySettings other = (LinuxSubscriptionsDiscoverySettings) obj;
        return Objects.equals(organizationIntegrationAsString(), other.organizationIntegrationAsString())
                && hasSourceRegions() == other.hasSourceRegions() && Objects.equals(sourceRegions(), other.sourceRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LinuxSubscriptionsDiscoverySettings")
                .add("OrganizationIntegration", organizationIntegrationAsString())
                .add("SourceRegions", hasSourceRegions() ? sourceRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationIntegration":
            return Optional.ofNullable(clazz.cast(organizationIntegrationAsString()));
        case "SourceRegions":
            return Optional.ofNullable(clazz.cast(sourceRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LinuxSubscriptionsDiscoverySettings, T> g) {
        return obj -> g.apply((LinuxSubscriptionsDiscoverySettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinuxSubscriptionsDiscoverySettings> {
        /**
         * <p>
         * Details if you have enabled resource discovery across your accounts in Organizations.
         * </p>
         * 
         * @param organizationIntegration
         *        Details if you have enabled resource discovery across your accounts in Organizations.
         * @see OrganizationIntegration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationIntegration
         */
        Builder organizationIntegration(String organizationIntegration);

        /**
         * <p>
         * Details if you have enabled resource discovery across your accounts in Organizations.
         * </p>
         * 
         * @param organizationIntegration
         *        Details if you have enabled resource discovery across your accounts in Organizations.
         * @see OrganizationIntegration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationIntegration
         */
        Builder organizationIntegration(OrganizationIntegration organizationIntegration);

        /**
         * <p>
         * The Regions in which to discover data for Linux subscriptions.
         * </p>
         * 
         * @param sourceRegions
         *        The Regions in which to discover data for Linux subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegions(Collection<String> sourceRegions);

        /**
         * <p>
         * The Regions in which to discover data for Linux subscriptions.
         * </p>
         * 
         * @param sourceRegions
         *        The Regions in which to discover data for Linux subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegions(String... sourceRegions);
    }

    static final class BuilderImpl implements Builder {
        private String organizationIntegration;

        private List<String> sourceRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LinuxSubscriptionsDiscoverySettings model) {
            organizationIntegration(model.organizationIntegration);
            sourceRegions(model.sourceRegions);
        }

        public final String getOrganizationIntegration() {
            return organizationIntegration;
        }

        public final void setOrganizationIntegration(String organizationIntegration) {
            this.organizationIntegration = organizationIntegration;
        }

        @Override
        public final Builder organizationIntegration(String organizationIntegration) {
            this.organizationIntegration = organizationIntegration;
            return this;
        }

        @Override
        public final Builder organizationIntegration(OrganizationIntegration organizationIntegration) {
            this.organizationIntegration(organizationIntegration == null ? null : organizationIntegration.toString());
            return this;
        }

        public final Collection<String> getSourceRegions() {
            if (sourceRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceRegions;
        }

        public final void setSourceRegions(Collection<String> sourceRegions) {
            this.sourceRegions = StringListCopier.copy(sourceRegions);
        }

        @Override
        public final Builder sourceRegions(Collection<String> sourceRegions) {
            this.sourceRegions = StringListCopier.copy(sourceRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRegions(String... sourceRegions) {
            sourceRegions(Arrays.asList(sourceRegions));
            return this;
        }

        @Override
        public LinuxSubscriptionsDiscoverySettings build() {
            return new LinuxSubscriptionsDiscoverySettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
