/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLicenseManagerReportGeneratorRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<DeleteLicenseManagerReportGeneratorRequest.Builder, DeleteLicenseManagerReportGeneratorRequest> {
    private static final SdkField<String> LICENSE_MANAGER_REPORT_GENERATOR_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LicenseManagerReportGeneratorArn")
            .getter(getter(DeleteLicenseManagerReportGeneratorRequest::licenseManagerReportGeneratorArn))
            .setter(setter(Builder::licenseManagerReportGeneratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseManagerReportGeneratorArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LICENSE_MANAGER_REPORT_GENERATOR_ARN_FIELD));

    private final String licenseManagerReportGeneratorArn;

    private DeleteLicenseManagerReportGeneratorRequest(BuilderImpl builder) {
        super(builder);
        this.licenseManagerReportGeneratorArn = builder.licenseManagerReportGeneratorArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the report generator to be deleted.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the report generator to be deleted.
     */
    public final String licenseManagerReportGeneratorArn() {
        return licenseManagerReportGeneratorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseManagerReportGeneratorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLicenseManagerReportGeneratorRequest)) {
            return false;
        }
        DeleteLicenseManagerReportGeneratorRequest other = (DeleteLicenseManagerReportGeneratorRequest) obj;
        return Objects.equals(licenseManagerReportGeneratorArn(), other.licenseManagerReportGeneratorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLicenseManagerReportGeneratorRequest")
                .add("LicenseManagerReportGeneratorArn", licenseManagerReportGeneratorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseManagerReportGeneratorArn":
            return Optional.ofNullable(clazz.cast(licenseManagerReportGeneratorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLicenseManagerReportGeneratorRequest, T> g) {
        return obj -> g.apply((DeleteLicenseManagerReportGeneratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteLicenseManagerReportGeneratorRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the report generator to be deleted.
         * </p>
         * 
         * @param licenseManagerReportGeneratorArn
         *        Amazon Resource Name (ARN) of the report generator to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String licenseManagerReportGeneratorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLicenseManagerReportGeneratorRequest model) {
            super(model);
            licenseManagerReportGeneratorArn(model.licenseManagerReportGeneratorArn);
        }

        public final String getLicenseManagerReportGeneratorArn() {
            return licenseManagerReportGeneratorArn;
        }

        public final void setLicenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn) {
            this.licenseManagerReportGeneratorArn = licenseManagerReportGeneratorArn;
        }

        @Override
        public final Builder licenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn) {
            this.licenseManagerReportGeneratorArn = licenseManagerReportGeneratorArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLicenseManagerReportGeneratorRequest build() {
            return new DeleteLicenseManagerReportGeneratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
