/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FulfillmentState {
    FULFILLED("Fulfilled"),
    FAILED("Failed"),
    READY_FOR_FULFILLMENT("ReadyForFulfillment"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FulfillmentState> VALUE_MAP;
    private final String value;

    private FulfillmentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FulfillmentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FulfillmentState> knownValues() {
        EnumSet<FulfillmentState> knownValues = EnumSet.allOf(FulfillmentState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FulfillmentState.class, FulfillmentState::toString);
    }
}

