/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIntentMetricsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListIntentMetricsRequest.Builder, ListIntentMetricsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListIntentMetricsRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDateTime").getter(getter(ListIntentMetricsRequest::startDateTime))
            .setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()).build();

    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDateTime").getter(getter(ListIntentMetricsRequest::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()).build();

    private static final SdkField<List<AnalyticsIntentMetric>> METRICS_FIELD = SdkField
            .<List<AnalyticsIntentMetric>> builder(MarshallingType.LIST)
            .memberName("metrics")
            .getter(getter(ListIntentMetricsRequest::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsIntentMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsIntentMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AnalyticsBinBySpecification>> BIN_BY_FIELD = SdkField
            .<List<AnalyticsBinBySpecification>> builder(MarshallingType.LIST)
            .memberName("binBy")
            .getter(getter(ListIntentMetricsRequest::binBy))
            .setter(setter(Builder::binBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsBinBySpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsBinBySpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AnalyticsIntentGroupBySpecification>> GROUP_BY_FIELD = SdkField
            .<List<AnalyticsIntentGroupBySpecification>> builder(MarshallingType.LIST)
            .memberName("groupBy")
            .getter(getter(ListIntentMetricsRequest::groupBy))
            .setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsIntentGroupBySpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsIntentGroupBySpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AnalyticsIntentFilter>> FILTERS_FIELD = SdkField
            .<List<AnalyticsIntentFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListIntentMetricsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsIntentFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsIntentFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListIntentMetricsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIntentMetricsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, METRICS_FIELD, BIN_BY_FIELD, GROUP_BY_FIELD, FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final Instant startDateTime;

    private final Instant endDateTime;

    private final List<AnalyticsIntentMetric> metrics;

    private final List<AnalyticsBinBySpecification> binBy;

    private final List<AnalyticsIntentGroupBySpecification> groupBy;

    private final List<AnalyticsIntentFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListIntentMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.metrics = builder.metrics;
        this.binBy = builder.binBy;
        this.groupBy = builder.groupBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier for the bot for which you want to retrieve intent metrics.
     * </p>
     * 
     * @return The identifier for the bot for which you want to retrieve intent metrics.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The timestamp that marks the beginning of the range of time for which you want to see intent metrics.
     * </p>
     * 
     * @return The timestamp that marks the beginning of the range of time for which you want to see intent metrics.
     */
    public final Instant startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * The date and time that marks the end of the range of time for which you want to see intent metrics.
     * </p>
     * 
     * @return The date and time that marks the end of the range of time for which you want to see intent metrics.
     */
    public final Instant endDateTime() {
        return endDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
     * return, and the order by which to organize the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return A list of objects, each of which contains a metric you want to list, the statistic for the metric you
     *         want to return, and the order by which to organize the results.
     */
    public final List<AnalyticsIntentMetric> metrics() {
        return metrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the BinBy property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasBinBy() {
        return binBy != null && !(binBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains specifications for organizing the results by time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBinBy} method.
     * </p>
     * 
     * @return A list of objects, each of which contains specifications for organizing the results by time.
     */
    public final List<AnalyticsBinBySpecification> binBy() {
        return binBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupBy() {
        return groupBy != null && !(groupBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which specifies how to group the results. You can group by the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IntentName</code> – The name of the intent.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IntentEndState</code> – The final state of the intent. The possible end states are detailed in <a
     * href="https://docs.aws.amazon.com/analytics-key-definitions-intents">Key definitions</a> in the user guide.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return A list of objects, each of which specifies how to group the results. You can group by the following
     *         criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IntentName</code> – The name of the intent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IntentEndState</code> – The final state of the intent. The possible end states are detailed in <a
     *         href="https://docs.aws.amazon.com/analytics-key-definitions-intents">Key definitions</a> in the user
     *         guide.
     *         </p>
     *         </li>
     */
    public final List<AnalyticsIntentGroupBySpecification> groupBy() {
        return groupBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which describes a condition by which you want to filter the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A list of objects, each of which describes a condition by which you want to filter the results.
     */
    public final List<AnalyticsIntentFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in each page of results. If there are fewer results than the maximum page
     * size, only the actual number of results are returned.
     * </p>
     * 
     * @return The maximum number of results to return in each page of results. If there are fewer results than the
     *         maximum page size, only the actual number of results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the ListIntentMetrics operation contains more results than specified in the maxResults
     * parameter, a token is returned in the response.
     * </p>
     * <p>
     * Use the returned token in the nextToken parameter of a ListIntentMetrics request to return the next page of
     * results. For a complete set of results, call the ListIntentMetrics operation until the nextToken returned in the
     * response is null.
     * </p>
     * 
     * @return If the response from the ListIntentMetrics operation contains more results than specified in the
     *         maxResults parameter, a token is returned in the response.</p>
     *         <p>
     *         Use the returned token in the nextToken parameter of a ListIntentMetrics request to return the next page
     *         of results. For a complete set of results, call the ListIntentMetrics operation until the nextToken
     *         returned in the response is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBinBy() ? binBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupBy() ? groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntentMetricsRequest)) {
            return false;
        }
        ListIntentMetricsRequest other = (ListIntentMetricsRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(startDateTime(), other.startDateTime())
                && Objects.equals(endDateTime(), other.endDateTime()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metrics(), other.metrics()) && hasBinBy() == other.hasBinBy()
                && Objects.equals(binBy(), other.binBy()) && hasGroupBy() == other.hasGroupBy()
                && Objects.equals(groupBy(), other.groupBy()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIntentMetricsRequest").add("BotId", botId()).add("StartDateTime", startDateTime())
                .add("EndDateTime", endDateTime()).add("Metrics", hasMetrics() ? metrics() : null)
                .add("BinBy", hasBinBy() ? binBy() : null).add("GroupBy", hasGroupBy() ? groupBy() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "startDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "endDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "binBy":
            return Optional.ofNullable(clazz.cast(binBy()));
        case "groupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIntentMetricsRequest, T> g) {
        return obj -> g.apply((ListIntentMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListIntentMetricsRequest> {
        /**
         * <p>
         * The identifier for the bot for which you want to retrieve intent metrics.
         * </p>
         * 
         * @param botId
         *        The identifier for the bot for which you want to retrieve intent metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The timestamp that marks the beginning of the range of time for which you want to see intent metrics.
         * </p>
         * 
         * @param startDateTime
         *        The timestamp that marks the beginning of the range of time for which you want to see intent metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(Instant startDateTime);

        /**
         * <p>
         * The date and time that marks the end of the range of time for which you want to see intent metrics.
         * </p>
         * 
         * @param endDateTime
         *        The date and time that marks the end of the range of time for which you want to see intent metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(Instant endDateTime);

        /**
         * <p>
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
         * return, and the order by which to organize the results.
         * </p>
         * 
         * @param metrics
         *        A list of objects, each of which contains a metric you want to list, the statistic for the metric you
         *        want to return, and the order by which to organize the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<AnalyticsIntentMetric> metrics);

        /**
         * <p>
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
         * return, and the order by which to organize the results.
         * </p>
         * 
         * @param metrics
         *        A list of objects, each of which contains a metric you want to list, the statistic for the metric you
         *        want to return, and the order by which to organize the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(AnalyticsIntentMetric... metrics);

        /**
         * <p>
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
         * return, and the order by which to organize the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #metrics(List<AnalyticsIntentMetric>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<AnalyticsIntentMetric>)
         */
        Builder metrics(Consumer<AnalyticsIntentMetric.Builder>... metrics);

        /**
         * <p>
         * A list of objects, each of which contains specifications for organizing the results by time.
         * </p>
         * 
         * @param binBy
         *        A list of objects, each of which contains specifications for organizing the results by time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binBy(Collection<AnalyticsBinBySpecification> binBy);

        /**
         * <p>
         * A list of objects, each of which contains specifications for organizing the results by time.
         * </p>
         * 
         * @param binBy
         *        A list of objects, each of which contains specifications for organizing the results by time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binBy(AnalyticsBinBySpecification... binBy);

        /**
         * <p>
         * A list of objects, each of which contains specifications for organizing the results by time.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification.Builder#build()} is
         * called immediately and its result is passed to {@link #binBy(List<AnalyticsBinBySpecification>)}.
         * 
         * @param binBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #binBy(java.util.Collection<AnalyticsBinBySpecification>)
         */
        Builder binBy(Consumer<AnalyticsBinBySpecification.Builder>... binBy);

        /**
         * <p>
         * A list of objects, each of which specifies how to group the results. You can group by the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IntentName</code> – The name of the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IntentEndState</code> – The final state of the intent. The possible end states are detailed in <a
         * href="https://docs.aws.amazon.com/analytics-key-definitions-intents">Key definitions</a> in the user guide.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupBy
         *        A list of objects, each of which specifies how to group the results. You can group by the following
         *        criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IntentName</code> – The name of the intent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IntentEndState</code> – The final state of the intent. The possible end states are detailed in
         *        <a href="https://docs.aws.amazon.com/analytics-key-definitions-intents">Key definitions</a> in the
         *        user guide.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(Collection<AnalyticsIntentGroupBySpecification> groupBy);

        /**
         * <p>
         * A list of objects, each of which specifies how to group the results. You can group by the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IntentName</code> – The name of the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IntentEndState</code> – The final state of the intent. The possible end states are detailed in <a
         * href="https://docs.aws.amazon.com/analytics-key-definitions-intents">Key definitions</a> in the user guide.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupBy
         *        A list of objects, each of which specifies how to group the results. You can group by the following
         *        criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IntentName</code> – The name of the intent.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IntentEndState</code> – The final state of the intent. The possible end states are detailed in
         *        <a href="https://docs.aws.amazon.com/analytics-key-definitions-intents">Key definitions</a> in the
         *        user guide.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(AnalyticsIntentGroupBySpecification... groupBy);

        /**
         * <p>
         * A list of objects, each of which specifies how to group the results. You can group by the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IntentName</code> – The name of the intent.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IntentEndState</code> – The final state of the intent. The possible end states are detailed in <a
         * href="https://docs.aws.amazon.com/analytics-key-definitions-intents">Key definitions</a> in the user guide.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupBySpecification.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupBySpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupBySpecification.Builder#build()}
         * is called immediately and its result is passed to {@link #groupBy(List<AnalyticsIntentGroupBySpecification>)}.
         * 
         * @param groupBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupBySpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupBy(java.util.Collection<AnalyticsIntentGroupBySpecification>)
         */
        Builder groupBy(Consumer<AnalyticsIntentGroupBySpecification.Builder>... groupBy);

        /**
         * <p>
         * A list of objects, each of which describes a condition by which you want to filter the results.
         * </p>
         * 
         * @param filters
         *        A list of objects, each of which describes a condition by which you want to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<AnalyticsIntentFilter> filters);

        /**
         * <p>
         * A list of objects, each of which describes a condition by which you want to filter the results.
         * </p>
         * 
         * @param filters
         *        A list of objects, each of which describes a condition by which you want to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AnalyticsIntentFilter... filters);

        /**
         * <p>
         * A list of objects, each of which describes a condition by which you want to filter the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<AnalyticsIntentFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<AnalyticsIntentFilter>)
         */
        Builder filters(Consumer<AnalyticsIntentFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return in each page of results. If there are fewer results than the maximum
         * page size, only the actual number of results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in each page of results. If there are fewer results than the
         *        maximum page size, only the actual number of results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the ListIntentMetrics operation contains more results than specified in the maxResults
         * parameter, a token is returned in the response.
         * </p>
         * <p>
         * Use the returned token in the nextToken parameter of a ListIntentMetrics request to return the next page of
         * results. For a complete set of results, call the ListIntentMetrics operation until the nextToken returned in
         * the response is null.
         * </p>
         * 
         * @param nextToken
         *        If the response from the ListIntentMetrics operation contains more results than specified in the
         *        maxResults parameter, a token is returned in the response.</p>
         *        <p>
         *        Use the returned token in the nextToken parameter of a ListIntentMetrics request to return the next
         *        page of results. For a complete set of results, call the ListIntentMetrics operation until the
         *        nextToken returned in the response is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private Instant startDateTime;

        private Instant endDateTime;

        private List<AnalyticsIntentMetric> metrics = DefaultSdkAutoConstructList.getInstance();

        private List<AnalyticsBinBySpecification> binBy = DefaultSdkAutoConstructList.getInstance();

        private List<AnalyticsIntentGroupBySpecification> groupBy = DefaultSdkAutoConstructList.getInstance();

        private List<AnalyticsIntentFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntentMetricsRequest model) {
            super(model);
            botId(model.botId);
            startDateTime(model.startDateTime);
            endDateTime(model.endDateTime);
            metrics(model.metrics);
            binBy(model.binBy);
            groupBy(model.groupBy);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Instant getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final List<AnalyticsIntentMetric.Builder> getMetrics() {
            List<AnalyticsIntentMetric.Builder> result = AnalyticsIntentMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<AnalyticsIntentMetric.BuilderImpl> metrics) {
            this.metrics = AnalyticsIntentMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<AnalyticsIntentMetric> metrics) {
            this.metrics = AnalyticsIntentMetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(AnalyticsIntentMetric... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<AnalyticsIntentMetric.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> AnalyticsIntentMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsBinBySpecification.Builder> getBinBy() {
            List<AnalyticsBinBySpecification.Builder> result = AnalyticsBinByListCopier.copyToBuilder(this.binBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinBy(Collection<AnalyticsBinBySpecification.BuilderImpl> binBy) {
            this.binBy = AnalyticsBinByListCopier.copyFromBuilder(binBy);
        }

        @Override
        public final Builder binBy(Collection<AnalyticsBinBySpecification> binBy) {
            this.binBy = AnalyticsBinByListCopier.copy(binBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binBy(AnalyticsBinBySpecification... binBy) {
            binBy(Arrays.asList(binBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binBy(Consumer<AnalyticsBinBySpecification.Builder>... binBy) {
            binBy(Stream.of(binBy).map(c -> AnalyticsBinBySpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentGroupBySpecification.Builder> getGroupBy() {
            List<AnalyticsIntentGroupBySpecification.Builder> result = AnalyticsIntentGroupByListCopier
                    .copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<AnalyticsIntentGroupBySpecification.BuilderImpl> groupBy) {
            this.groupBy = AnalyticsIntentGroupByListCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<AnalyticsIntentGroupBySpecification> groupBy) {
            this.groupBy = AnalyticsIntentGroupByListCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(AnalyticsIntentGroupBySpecification... groupBy) {
            groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<AnalyticsIntentGroupBySpecification.Builder>... groupBy) {
            groupBy(Stream.of(groupBy).map(c -> AnalyticsIntentGroupBySpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentFilter.Builder> getFilters() {
            List<AnalyticsIntentFilter.Builder> result = AnalyticsIntentFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AnalyticsIntentFilter.BuilderImpl> filters) {
            this.filters = AnalyticsIntentFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AnalyticsIntentFilter> filters) {
            this.filters = AnalyticsIntentFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AnalyticsIntentFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AnalyticsIntentFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> AnalyticsIntentFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIntentMetricsRequest build() {
            return new ListIntentMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
