/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomVocabularyItemsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListCustomVocabularyItemsRequest.Builder, ListCustomVocabularyItemsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListCustomVocabularyItemsRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListCustomVocabularyItemsRequest::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListCustomVocabularyItemsRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCustomVocabularyItemsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCustomVocabularyItemsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final Integer maxResults;

    private final String nextToken;

    private ListCustomVocabularyItemsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the version of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @return The identifier of the version of the bot associated with this custom vocabulary.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The bot version of the bot to the list custom vocabulary request.
     * </p>
     * 
     * @return The bot version of the bot to the list custom vocabulary request.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale where this custom vocabulary is used. The string must match one of the
     * supported locales. For more information, see Supported languages
     * (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     * </p>
     * 
     * @return The identifier of the language and locale where this custom vocabulary is used. The string must match one
     *         of the supported locales. For more information, see Supported languages
     *         (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The maximum number of items returned by the list operation.
     * </p>
     * 
     * @return The maximum number of items returned by the list operation.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The nextToken identifier to the list custom vocabulary request.
     * </p>
     * 
     * @return The nextToken identifier to the list custom vocabulary request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomVocabularyItemsRequest)) {
            return false;
        }
        ListCustomVocabularyItemsRequest other = (ListCustomVocabularyItemsRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomVocabularyItemsRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomVocabularyItemsRequest, T> g) {
        return obj -> g.apply((ListCustomVocabularyItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomVocabularyItemsRequest> {
        /**
         * <p>
         * The identifier of the version of the bot associated with this custom vocabulary.
         * </p>
         * 
         * @param botId
         *        The identifier of the version of the bot associated with this custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The bot version of the bot to the list custom vocabulary request.
         * </p>
         * 
         * @param botVersion
         *        The bot version of the bot to the list custom vocabulary request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale where this custom vocabulary is used. The string must match one of
         * the supported locales. For more information, see Supported languages
         * (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale where this custom vocabulary is used. The string must match
         *        one of the supported locales. For more information, see Supported languages
         *        (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The maximum number of items returned by the list operation.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items returned by the list operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The nextToken identifier to the list custom vocabulary request.
         * </p>
         * 
         * @param nextToken
         *        The nextToken identifier to the list custom vocabulary request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomVocabularyItemsRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomVocabularyItemsRequest build() {
            return new ListCustomVocabularyItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
