/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBotVersionResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeBotVersionResponse.Builder, DescribeBotVersionResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DescribeBotVersionResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(DescribeBotVersionResponse::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DescribeBotVersionResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeBotVersionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DescribeBotVersionResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.<DataPrivacy> builder(MarshallingType.SDK_POJO)
            .memberName("dataPrivacy").getter(getter(DescribeBotVersionResponse::dataPrivacy))
            .setter(setter(Builder::dataPrivacy)).constructor(DataPrivacy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(DescribeBotVersionResponse::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botStatus").getter(getter(DescribeBotVersionResponse::botStatusAsString))
            .setter(setter(Builder::botStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeBotVersionResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeBotVersionResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<List<ParentBotNetwork>> PARENT_BOT_NETWORKS_FIELD = SdkField
            .<List<ParentBotNetwork>> builder(MarshallingType.LIST)
            .memberName("parentBotNetworks")
            .getter(getter(DescribeBotVersionResponse::parentBotNetworks))
            .setter(setter(Builder::parentBotNetworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentBotNetworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParentBotNetwork> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParentBotNetwork::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botType").getter(getter(DescribeBotVersionResponse::botTypeAsString)).setter(setter(Builder::botType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botType").build()).build();

    private static final SdkField<List<BotMember>> BOT_MEMBERS_FIELD = SdkField
            .<List<BotMember>> builder(MarshallingType.LIST)
            .memberName("botMembers")
            .getter(getter(DescribeBotVersionResponse::botMembers))
            .setter(setter(Builder::botMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD,
            BOT_VERSION_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD,
            BOT_STATUS_FIELD, FAILURE_REASONS_FIELD, CREATION_DATE_TIME_FIELD, PARENT_BOT_NETWORKS_FIELD, BOT_TYPE_FIELD,
            BOT_MEMBERS_FIELD));

    private final String botId;

    private final String botName;

    private final String botVersion;

    private final String description;

    private final String roleArn;

    private final DataPrivacy dataPrivacy;

    private final Integer idleSessionTTLInSeconds;

    private final String botStatus;

    private final List<String> failureReasons;

    private final Instant creationDateTime;

    private final List<ParentBotNetwork> parentBotNetworks;

    private final String botType;

    private final List<BotMember> botMembers;

    private DescribeBotVersionResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botName = builder.botName;
        this.botVersion = builder.botVersion;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.botStatus = builder.botStatus;
        this.failureReasons = builder.failureReasons;
        this.creationDateTime = builder.creationDateTime;
        this.parentBotNetworks = builder.parentBotNetworks;
        this.botType = builder.botType;
        this.botMembers = builder.botMembers;
    }

    /**
     * <p>
     * The identifier of the bot that contains the version.
     * </p>
     * 
     * @return The identifier of the bot that contains the version.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The name of the bot that contains the version.
     * </p>
     * 
     * @return The name of the bot that contains the version.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The version of the bot that was described.
     * </p>
     * 
     * @return The version of the bot that was described.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The description specified for the bot.
     * </p>
     * 
     * @return The description specified for the bot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Data privacy settings for the bot version.
     * </p>
     * 
     * @return Data privacy settings for the bot version.
     */
    public final DataPrivacy dataPrivacy() {
        return dataPrivacy;
    }

    /**
     * <p>
     * The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.
     * </p>
     * 
     * @return The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot. When the status is <code>Available</code>, the bot version is ready for
     *         use.
     * @see BotStatus
     */
    public final BotStatus botStatus() {
        return BotStatus.fromValue(botStatus);
    }

    /**
     * <p>
     * The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot. When the status is <code>Available</code>, the bot version is ready for
     *         use.
     * @see BotStatus
     */
    public final String botStatusAsString() {
        return botStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version couldn't
     * be built.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version
     *         couldn't be built.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * <p>
     * A timestamp of the date and time that the bot version was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the bot version was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParentBotNetworks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParentBotNetworks() {
        return parentBotNetworks != null && !(parentBotNetworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the networks to which the bot version you described belongs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParentBotNetworks} method.
     * </p>
     * 
     * @return A list of the networks to which the bot version you described belongs.
     */
    public final List<ParentBotNetwork> parentBotNetworks() {
        return parentBotNetworks;
    }

    /**
     * <p>
     * The type of the bot in the version that was described.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botType} will
     * return {@link BotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botTypeAsString}.
     * </p>
     * 
     * @return The type of the bot in the version that was described.
     * @see BotType
     */
    public final BotType botType() {
        return BotType.fromValue(botType);
    }

    /**
     * <p>
     * The type of the bot in the version that was described.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botType} will
     * return {@link BotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botTypeAsString}.
     * </p>
     * 
     * @return The type of the bot in the version that was described.
     * @see BotType
     */
    public final String botTypeAsString() {
        return botType;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotMembers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBotMembers() {
        return botMembers != null && !(botMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The members of bot network in the version that was described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotMembers} method.
     * </p>
     * 
     * @return The members of bot network in the version that was described.
     */
    public final List<BotMember> botMembers() {
        return botMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasParentBotNetworks() ? parentBotNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(botTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotMembers() ? botMembers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotVersionResponse)) {
            return false;
        }
        DescribeBotVersionResponse other = (DescribeBotVersionResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botName(), other.botName())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(description(), other.description())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(dataPrivacy(), other.dataPrivacy())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(botStatusAsString(), other.botStatusAsString())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && hasParentBotNetworks() == other.hasParentBotNetworks()
                && Objects.equals(parentBotNetworks(), other.parentBotNetworks())
                && Objects.equals(botTypeAsString(), other.botTypeAsString()) && hasBotMembers() == other.hasBotMembers()
                && Objects.equals(botMembers(), other.botMembers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBotVersionResponse").add("BotId", botId()).add("BotName", botName())
                .add("BotVersion", botVersion()).add("Description", description()).add("RoleArn", roleArn())
                .add("DataPrivacy", dataPrivacy()).add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds())
                .add("BotStatus", botStatusAsString()).add("FailureReasons", hasFailureReasons() ? failureReasons() : null)
                .add("CreationDateTime", creationDateTime())
                .add("ParentBotNetworks", hasParentBotNetworks() ? parentBotNetworks() : null).add("BotType", botTypeAsString())
                .add("BotMembers", hasBotMembers() ? botMembers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "dataPrivacy":
            return Optional.ofNullable(clazz.cast(dataPrivacy()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "botStatus":
            return Optional.ofNullable(clazz.cast(botStatusAsString()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "parentBotNetworks":
            return Optional.ofNullable(clazz.cast(parentBotNetworks()));
        case "botType":
            return Optional.ofNullable(clazz.cast(botTypeAsString()));
        case "botMembers":
            return Optional.ofNullable(clazz.cast(botMembers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotVersionResponse, T> g) {
        return obj -> g.apply((DescribeBotVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBotVersionResponse> {
        /**
         * <p>
         * The identifier of the bot that contains the version.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The name of the bot that contains the version.
         * </p>
         * 
         * @param botName
         *        The name of the bot that contains the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The version of the bot that was described.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The description specified for the bot.
         * </p>
         * 
         * @param description
         *        The description specified for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Data privacy settings for the bot version.
         * </p>
         * 
         * @param dataPrivacy
         *        Data privacy settings for the bot version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPrivacy(DataPrivacy dataPrivacy);

        /**
         * <p>
         * Data privacy settings for the bot version.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPrivacy.Builder} avoiding the need to
         * create one manually via {@link DataPrivacy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPrivacy.Builder#build()} is called immediately and its result
         * is passed to {@link #dataPrivacy(DataPrivacy)}.
         * 
         * @param dataPrivacy
         *        a consumer that will call methods on {@link DataPrivacy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPrivacy(DataPrivacy)
         */
        default Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return dataPrivacy(DataPrivacy.builder().applyMutation(dataPrivacy).build());
        }

        /**
         * <p>
         * The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.
         * </p>
         * 
         * @param botStatus
         *        The current status of the bot. When the status is <code>Available</code>, the bot version is ready for
         *        use.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(String botStatus);

        /**
         * <p>
         * The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.
         * </p>
         * 
         * @param botStatus
         *        The current status of the bot. When the status is <code>Available</code>, the bot version is ready for
         *        use.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(BotStatus botStatus);

        /**
         * <p>
         * If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version
         * couldn't be built.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version
         *        couldn't be built.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version
         * couldn't be built.
         * </p>
         * 
         * @param failureReasons
         *        If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version
         *        couldn't be built.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * <p>
         * A timestamp of the date and time that the bot version was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the bot version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A list of the networks to which the bot version you described belongs.
         * </p>
         * 
         * @param parentBotNetworks
         *        A list of the networks to which the bot version you described belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentBotNetworks(Collection<ParentBotNetwork> parentBotNetworks);

        /**
         * <p>
         * A list of the networks to which the bot version you described belongs.
         * </p>
         * 
         * @param parentBotNetworks
         *        A list of the networks to which the bot version you described belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentBotNetworks(ParentBotNetwork... parentBotNetworks);

        /**
         * <p>
         * A list of the networks to which the bot version you described belongs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ParentBotNetwork.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.ParentBotNetwork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ParentBotNetwork.Builder#build()} is called
         * immediately and its result is passed to {@link #parentBotNetworks(List<ParentBotNetwork>)}.
         * 
         * @param parentBotNetworks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ParentBotNetwork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentBotNetworks(java.util.Collection<ParentBotNetwork>)
         */
        Builder parentBotNetworks(Consumer<ParentBotNetwork.Builder>... parentBotNetworks);

        /**
         * <p>
         * The type of the bot in the version that was described.
         * </p>
         * 
         * @param botType
         *        The type of the bot in the version that was described.
         * @see BotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotType
         */
        Builder botType(String botType);

        /**
         * <p>
         * The type of the bot in the version that was described.
         * </p>
         * 
         * @param botType
         *        The type of the bot in the version that was described.
         * @see BotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotType
         */
        Builder botType(BotType botType);

        /**
         * <p>
         * The members of bot network in the version that was described.
         * </p>
         * 
         * @param botMembers
         *        The members of bot network in the version that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMembers(Collection<BotMember> botMembers);

        /**
         * <p>
         * The members of bot network in the version that was described.
         * </p>
         * 
         * @param botMembers
         *        The members of bot network in the version that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMembers(BotMember... botMembers);

        /**
         * <p>
         * The members of bot network in the version that was described.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember.Builder#build()} is called immediately and
         * its result is passed to {@link #botMembers(List<BotMember>)}.
         * 
         * @param botMembers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BotMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botMembers(java.util.Collection<BotMember>)
         */
        Builder botMembers(Consumer<BotMember.Builder>... botMembers);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botName;

        private String botVersion;

        private String description;

        private String roleArn;

        private DataPrivacy dataPrivacy;

        private Integer idleSessionTTLInSeconds;

        private String botStatus;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDateTime;

        private List<ParentBotNetwork> parentBotNetworks = DefaultSdkAutoConstructList.getInstance();

        private String botType;

        private List<BotMember> botMembers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotVersionResponse model) {
            super(model);
            botId(model.botId);
            botName(model.botName);
            botVersion(model.botVersion);
            description(model.description);
            roleArn(model.roleArn);
            dataPrivacy(model.dataPrivacy);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            botStatus(model.botStatus);
            failureReasons(model.failureReasons);
            creationDateTime(model.creationDateTime);
            parentBotNetworks(model.parentBotNetworks);
            botType(model.botType);
            botMembers(model.botMembers);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return dataPrivacy != null ? dataPrivacy.toBuilder() : null;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getBotStatus() {
            return botStatus;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final List<ParentBotNetwork.Builder> getParentBotNetworks() {
            List<ParentBotNetwork.Builder> result = ParentBotNetworksCopier.copyToBuilder(this.parentBotNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParentBotNetworks(Collection<ParentBotNetwork.BuilderImpl> parentBotNetworks) {
            this.parentBotNetworks = ParentBotNetworksCopier.copyFromBuilder(parentBotNetworks);
        }

        @Override
        public final Builder parentBotNetworks(Collection<ParentBotNetwork> parentBotNetworks) {
            this.parentBotNetworks = ParentBotNetworksCopier.copy(parentBotNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentBotNetworks(ParentBotNetwork... parentBotNetworks) {
            parentBotNetworks(Arrays.asList(parentBotNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentBotNetworks(Consumer<ParentBotNetwork.Builder>... parentBotNetworks) {
            parentBotNetworks(Stream.of(parentBotNetworks).map(c -> ParentBotNetwork.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getBotType() {
            return botType;
        }

        public final void setBotType(String botType) {
            this.botType = botType;
        }

        @Override
        public final Builder botType(String botType) {
            this.botType = botType;
            return this;
        }

        @Override
        public final Builder botType(BotType botType) {
            this.botType(botType == null ? null : botType.toString());
            return this;
        }

        public final List<BotMember.Builder> getBotMembers() {
            List<BotMember.Builder> result = BotMembersCopier.copyToBuilder(this.botMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotMembers(Collection<BotMember.BuilderImpl> botMembers) {
            this.botMembers = BotMembersCopier.copyFromBuilder(botMembers);
        }

        @Override
        public final Builder botMembers(Collection<BotMember> botMembers) {
            this.botMembers = BotMembersCopier.copy(botMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botMembers(BotMember... botMembers) {
            botMembers(Arrays.asList(botMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botMembers(Consumer<BotMember.Builder>... botMembers) {
            botMembers(Stream.of(botMembers).map(c -> BotMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeBotVersionResponse build() {
            return new DescribeBotVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
