/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the category by which to group the intent stages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsIntentStageGroupBySpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsIntentStageGroupBySpecification.Builder, AnalyticsIntentStageGroupBySpecification> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AnalyticsIntentStageGroupBySpecification::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private AnalyticsIntentStageGroupBySpecification(BuilderImpl builder) {
        this.name = builder.name;
    }

    /**
     * <p>
     * Specifies whether to group the intent stages by their name or the intent to which the session was switched.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsIntentStageField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specifies whether to group the intent stages by their name or the intent to which the session was
     *         switched.
     * @see AnalyticsIntentStageField
     */
    public final AnalyticsIntentStageField name() {
        return AnalyticsIntentStageField.fromValue(name);
    }

    /**
     * <p>
     * Specifies whether to group the intent stages by their name or the intent to which the session was switched.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsIntentStageField#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specifies whether to group the intent stages by their name or the intent to which the session was
     *         switched.
     * @see AnalyticsIntentStageField
     */
    public final String nameAsString() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsIntentStageGroupBySpecification)) {
            return false;
        }
        AnalyticsIntentStageGroupBySpecification other = (AnalyticsIntentStageGroupBySpecification) obj;
        return Objects.equals(nameAsString(), other.nameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsIntentStageGroupBySpecification").add("Name", nameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsIntentStageGroupBySpecification, T> g) {
        return obj -> g.apply((AnalyticsIntentStageGroupBySpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsIntentStageGroupBySpecification> {
        /**
         * <p>
         * Specifies whether to group the intent stages by their name or the intent to which the session was switched.
         * </p>
         * 
         * @param name
         *        Specifies whether to group the intent stages by their name or the intent to which the session was
         *        switched.
         * @see AnalyticsIntentStageField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsIntentStageField
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether to group the intent stages by their name or the intent to which the session was switched.
         * </p>
         * 
         * @param name
         *        Specifies whether to group the intent stages by their name or the intent to which the session was
         *        switched.
         * @see AnalyticsIntentStageField
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsIntentStageField
         */
        Builder name(AnalyticsIntentStageField name);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsIntentStageGroupBySpecification model) {
            name(model.name);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AnalyticsIntentStageField name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        @Override
        public AnalyticsIntentStageGroupBySpecification build() {
            return new AnalyticsIntentStageGroupBySpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
