/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specification of an agent turn.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentTurnSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentTurnSpecification.Builder, AgentTurnSpecification> {
    private static final SdkField<String> AGENT_PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentPrompt").getter(getter(AgentTurnSpecification::agentPrompt)).setter(setter(Builder::agentPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentPrompt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_PROMPT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentPrompt;

    private AgentTurnSpecification(BuilderImpl builder) {
        this.agentPrompt = builder.agentPrompt;
    }

    /**
     * <p>
     * The agent prompt for the agent turn in a test set.
     * </p>
     * 
     * @return The agent prompt for the agent turn in a test set.
     */
    public final String agentPrompt() {
        return agentPrompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentPrompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentTurnSpecification)) {
            return false;
        }
        AgentTurnSpecification other = (AgentTurnSpecification) obj;
        return Objects.equals(agentPrompt(), other.agentPrompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentTurnSpecification").add("AgentPrompt", agentPrompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentPrompt":
            return Optional.ofNullable(clazz.cast(agentPrompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentTurnSpecification, T> g) {
        return obj -> g.apply((AgentTurnSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentTurnSpecification> {
        /**
         * <p>
         * The agent prompt for the agent turn in a test set.
         * </p>
         * 
         * @param agentPrompt
         *        The agent prompt for the agent turn in a test set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentPrompt(String agentPrompt);
    }

    static final class BuilderImpl implements Builder {
        private String agentPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentTurnSpecification model) {
            agentPrompt(model.agentPrompt);
        }

        public final String getAgentPrompt() {
            return agentPrompt;
        }

        public final void setAgentPrompt(String agentPrompt) {
            this.agentPrompt = agentPrompt;
        }

        @Override
        public final Builder agentPrompt(String agentPrompt) {
            this.agentPrompt = agentPrompt;
            return this;
        }

        @Override
        public AgentTurnSpecification build() {
            return new AgentTurnSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
