/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchCreateCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchDeleteCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BatchUpdateCustomVocabularyItemResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ConflictException;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateTestSetDiscrepancyReportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteTestSetResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestExecutionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetGenerationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeTestSetResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.GetTestExecutionArtifactsUrlResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.InternalServerException;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Exception;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListCustomVocabularyItemsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentPathsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.PreconditionFailedException;
import software.amazon.awssdk.services.lexmodelsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestExecutionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartTestSetGenerationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StopBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ThrottlingException;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateTestSetResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ValidationException;
import software.amazon.awssdk.services.lexmodelsv2.transform.BatchCreateCustomVocabularyItemRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.BatchDeleteCustomVocabularyItemRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.BatchUpdateCustomVocabularyItemRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.BuildBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateResourcePolicyStatementRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateTestSetDiscrepancyReportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteCustomVocabularyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteResourcePolicyStatementRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteTestSetRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteUtterancesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotRecommendationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeCustomVocabularyMetadataRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeTestExecutionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeTestSetDiscrepancyReportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeTestSetGenerationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeTestSetRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.GetTestExecutionArtifactsUrlRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListAggregatedUtterancesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotAliasesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotLocalesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBuiltInIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBuiltInSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListCustomVocabularyItemsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentMetricsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentPathsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentStageMetricsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListRecommendedIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSessionAnalyticsDataRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSessionMetricsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSlotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTestExecutionResultItemsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTestExecutionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTestSetRecordsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTestSetsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListUtteranceAnalyticsDataRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListUtteranceMetricsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.SearchAssociatedTranscriptsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StartBotRecommendationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StartTestExecutionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StartTestSetGenerationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StopBotRecommendationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotRecommendationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateTestSetRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.waiters.LexModelsV2AsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link LexModelsV2AsyncClient}.
 *
 * @see LexModelsV2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLexModelsV2AsyncClient implements LexModelsV2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLexModelsV2AsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final LexModelsV2ServiceClientConfiguration serviceClientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultLexModelsV2AsyncClient(LexModelsV2ServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchCreateCustomVocabularyItemRequest
     * @return A Java Future containing the result of the BatchCreateCustomVocabularyItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BatchCreateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchCreateCustomVocabularyItemResponse> batchCreateCustomVocabularyItem(
            BatchCreateCustomVocabularyItemRequest batchCreateCustomVocabularyItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateCustomVocabularyItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateCustomVocabularyItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchCreateCustomVocabularyItemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchCreateCustomVocabularyItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchCreateCustomVocabularyItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchCreateCustomVocabularyItemRequest, BatchCreateCustomVocabularyItemResponse>()
                            .withOperationName("BatchCreateCustomVocabularyItem")
                            .withMarshaller(new BatchCreateCustomVocabularyItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchCreateCustomVocabularyItemRequest));
            CompletableFuture<BatchCreateCustomVocabularyItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchDeleteCustomVocabularyItemRequest
     * @return A Java Future containing the result of the BatchDeleteCustomVocabularyItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BatchDeleteCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteCustomVocabularyItemResponse> batchDeleteCustomVocabularyItem(
            BatchDeleteCustomVocabularyItemRequest batchDeleteCustomVocabularyItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteCustomVocabularyItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteCustomVocabularyItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteCustomVocabularyItemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteCustomVocabularyItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteCustomVocabularyItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteCustomVocabularyItemRequest, BatchDeleteCustomVocabularyItemResponse>()
                            .withOperationName("BatchDeleteCustomVocabularyItem")
                            .withMarshaller(new BatchDeleteCustomVocabularyItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchDeleteCustomVocabularyItemRequest));
            CompletableFuture<BatchDeleteCustomVocabularyItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param batchUpdateCustomVocabularyItemRequest
     * @return A Java Future containing the result of the BatchUpdateCustomVocabularyItem operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BatchUpdateCustomVocabularyItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchUpdateCustomVocabularyItemResponse> batchUpdateCustomVocabularyItem(
            BatchUpdateCustomVocabularyItemRequest batchUpdateCustomVocabularyItemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateCustomVocabularyItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateCustomVocabularyItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchUpdateCustomVocabularyItemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchUpdateCustomVocabularyItemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchUpdateCustomVocabularyItemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateCustomVocabularyItemRequest, BatchUpdateCustomVocabularyItemResponse>()
                            .withOperationName("BatchUpdateCustomVocabularyItem")
                            .withMarshaller(new BatchUpdateCustomVocabularyItemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchUpdateCustomVocabularyItemRequest));
            CompletableFuture<BatchUpdateCustomVocabularyItemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     *
     * @param buildBotLocaleRequest
     * @return A Java Future containing the result of the BuildBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BuildBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BuildBotLocaleResponse> buildBotLocale(BuildBotLocaleRequest buildBotLocaleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, buildBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BuildBotLocale");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BuildBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BuildBotLocaleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BuildBotLocaleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BuildBotLocaleRequest, BuildBotLocaleResponse>()
                            .withOperationName("BuildBotLocale")
                            .withMarshaller(new BuildBotLocaleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(buildBotLocaleRequest));
            CompletableFuture<BuildBotLocaleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     *
     * @param createBotRequest
     * @return A Java Future containing the result of the CreateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBotResponse> createBot(CreateBotRequest createBotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateBotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBotRequest, CreateBotResponse>().withOperationName("CreateBot")
                            .withMarshaller(new CreateBotRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBotRequest));
            CompletableFuture<CreateBotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     *
     * @param createBotAliasRequest
     * @return A Java Future containing the result of the CreateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBotAliasResponse> createBotAlias(CreateBotAliasRequest createBotAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBotAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBotAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBotAliasRequest, CreateBotAliasResponse>()
                            .withOperationName("CreateBotAlias")
                            .withMarshaller(new CreateBotAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createBotAliasRequest));
            CompletableFuture<CreateBotAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     *
     * @param createBotLocaleRequest
     * @return A Java Future containing the result of the CreateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBotLocaleResponse> createBotLocale(CreateBotLocaleRequest createBotLocaleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotLocale");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBotLocaleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBotLocaleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBotLocaleRequest, CreateBotLocaleResponse>()
                            .withOperationName("CreateBotLocale")
                            .withMarshaller(new CreateBotLocaleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createBotLocaleRequest));
            CompletableFuture<CreateBotLocaleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     *
     * @param createBotVersionRequest
     * @return A Java Future containing the result of the CreateBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBotVersionResponse> createBotVersion(CreateBotVersionRequest createBotVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBotVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBotVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBotVersionRequest, CreateBotVersionResponse>()
                            .withOperationName("CreateBotVersion")
                            .withMarshaller(new CreateBotVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createBotVersionRequest));
            CompletableFuture<CreateBotVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory
     * structure that contains JSON files that define the bot.
     * </p>
     * <p>
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive
     * contain only the definition of a single bot locale.
     * </p>
     * <p>
     * For more information about exporting bots, and about the structure of the export archive, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a>
     * </p>
     *
     * @param createExportRequest
     * @return A Java Future containing the result of the CreateExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateExportResponse> createExport(CreateExportRequest createExportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateExportRequest, CreateExportResponse>()
                            .withOperationName("CreateExport").withMarshaller(new CreateExportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createExportRequest));
            CompletableFuture<CreateExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     *
     * @param createIntentRequest
     * @return A Java Future containing the result of the CreateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIntentResponse> createIntent(CreateIntentRequest createIntentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateIntentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIntentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIntentRequest, CreateIntentResponse>()
                            .withOperationName("CreateIntent").withMarshaller(new CreateIntentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createIntentRequest));
            CompletableFuture<CreateIntentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new resource policy with the specified policy statements.
     * </p>
     *
     * @param createResourcePolicyRequest
     * @return A Java Future containing the result of the CreateResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourcePolicyResponse> createResourcePolicy(
            CreateResourcePolicyRequest createResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourcePolicyRequest, CreateResourcePolicyResponse>()
                            .withOperationName("CreateResourcePolicy")
                            .withMarshaller(new CreateResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createResourcePolicyRequest));
            CompletableFuture<CreateResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added
     * to the current resource policy. If a policy doesn't exist, a new policy is created.
     * </p>
     * <p>
     * You can't create a resource policy statement that allows cross-account access.
     * </p>
     *
     * @param createResourcePolicyStatementRequest
     * @return A Java Future containing the result of the CreateResourcePolicyStatement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourcePolicyStatementResponse> createResourcePolicyStatement(
            CreateResourcePolicyStatementRequest createResourcePolicyStatementRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createResourcePolicyStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourcePolicyStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourcePolicyStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourcePolicyStatementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourcePolicyStatementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourcePolicyStatementRequest, CreateResourcePolicyStatementResponse>()
                            .withOperationName("CreateResourcePolicyStatement")
                            .withMarshaller(new CreateResourcePolicyStatementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createResourcePolicyStatementRequest));
            CompletableFuture<CreateResourcePolicyStatementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     *
     * @param createSlotRequest
     * @return A Java Future containing the result of the CreateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSlotResponse> createSlot(CreateSlotRequest createSlotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSlot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSlotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSlotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSlotRequest, CreateSlotResponse>().withOperationName("CreateSlot")
                            .withMarshaller(new CreateSlotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSlotRequest));
            CompletableFuture<CreateSlotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     *
     * @param createSlotTypeRequest
     * @return A Java Future containing the result of the CreateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSlotTypeResponse> createSlotType(CreateSlotTypeRequest createSlotTypeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSlotType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSlotTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSlotTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSlotTypeRequest, CreateSlotTypeResponse>()
                            .withOperationName("CreateSlotType")
                            .withMarshaller(new CreateSlotTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSlotTypeRequest));
            CompletableFuture<CreateSlotTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a report that describes the differences between the bot and the test set.
     * </p>
     *
     * @param createTestSetDiscrepancyReportRequest
     * @return A Java Future containing the result of the CreateTestSetDiscrepancyReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateTestSetDiscrepancyReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateTestSetDiscrepancyReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTestSetDiscrepancyReportResponse> createTestSetDiscrepancyReport(
            CreateTestSetDiscrepancyReportRequest createTestSetDiscrepancyReportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTestSetDiscrepancyReportRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTestSetDiscrepancyReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTestSetDiscrepancyReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTestSetDiscrepancyReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTestSetDiscrepancyReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTestSetDiscrepancyReportRequest, CreateTestSetDiscrepancyReportResponse>()
                            .withOperationName("CreateTestSetDiscrepancyReport")
                            .withMarshaller(new CreateTestSetDiscrepancyReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTestSetDiscrepancyReportRequest));
            CompletableFuture<CreateTestSetDiscrepancyReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     * </p>
     *
     * @param createUploadUrlRequest
     * @return A Java Future containing the result of the CreateUploadUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUploadUrlResponse> createUploadUrl(CreateUploadUrlRequest createUploadUrlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUploadUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUploadUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUploadUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUploadUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUploadUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUploadUrlRequest, CreateUploadUrlResponse>()
                            .withOperationName("CreateUploadUrl")
                            .withMarshaller(new CreateUploadUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createUploadUrlRequest));
            CompletableFuture<CreateUploadUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     *
     * @param deleteBotRequest
     * @return A Java Future containing the result of the DeleteBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotResponse> deleteBot(DeleteBotRequest deleteBotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteBotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBotRequest, DeleteBotResponse>().withOperationName("DeleteBot")
                            .withMarshaller(new DeleteBotRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBotRequest));
            CompletableFuture<DeleteBotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return A Java Future containing the result of the DeleteBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotAliasResponse> deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBotAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBotAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBotAliasRequest, DeleteBotAliasResponse>()
                            .withOperationName("DeleteBotAlias")
                            .withMarshaller(new DeleteBotAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBotAliasRequest));
            CompletableFuture<DeleteBotAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     *
     * @param deleteBotLocaleRequest
     * @return A Java Future containing the result of the DeleteBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotLocaleResponse> deleteBotLocale(DeleteBotLocaleRequest deleteBotLocaleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotLocale");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBotLocaleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBotLocaleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBotLocaleRequest, DeleteBotLocaleResponse>()
                            .withOperationName("DeleteBotLocale")
                            .withMarshaller(new DeleteBotLocaleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBotLocaleRequest));
            CompletableFuture<DeleteBotLocaleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all versions of a bot, use the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html">DeleteBot</a> operation.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return A Java Future containing the result of the DeleteBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBotVersionResponse> deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBotVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBotVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBotVersionRequest, DeleteBotVersionResponse>()
                            .withOperationName("DeleteBotVersion")
                            .withMarshaller(new DeleteBotVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBotVersionRequest));
            CompletableFuture<DeleteBotVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a custom vocabulary from the specified locale in the specified bot.
     * </p>
     *
     * @param deleteCustomVocabularyRequest
     * @return A Java Future containing the result of the DeleteCustomVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteCustomVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomVocabularyResponse> deleteCustomVocabulary(
            DeleteCustomVocabularyRequest deleteCustomVocabularyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomVocabularyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomVocabulary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomVocabularyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCustomVocabularyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCustomVocabularyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomVocabularyRequest, DeleteCustomVocabularyResponse>()
                            .withOperationName("DeleteCustomVocabulary")
                            .withMarshaller(new DeleteCustomVocabularyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCustomVocabularyRequest));
            CompletableFuture<DeleteCustomVocabularyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a previous export and the associated files stored in an S3 bucket.
     * </p>
     *
     * @param deleteExportRequest
     * @return A Java Future containing the result of the DeleteExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteExportResponse> deleteExport(DeleteExportRequest deleteExportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteExportRequest, DeleteExportResponse>()
                            .withOperationName("DeleteExport").withMarshaller(new DeleteExportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteExportRequest));
            CompletableFuture<DeleteExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a previous import and the associated file stored in an S3 bucket.
     * </p>
     *
     * @param deleteImportRequest
     * @return A Java Future containing the result of the DeleteImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImportResponse> deleteImport(DeleteImportRequest deleteImportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteImportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteImportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImportRequest, DeleteImportResponse>()
                            .withOperationName("DeleteImport").withMarshaller(new DeleteImportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteImportRequest));
            CompletableFuture<DeleteImportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     *
     * @param deleteIntentRequest
     * @return A Java Future containing the result of the DeleteIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIntentResponse> deleteIntent(DeleteIntentRequest deleteIntentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteIntentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIntentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIntentRequest, DeleteIntentResponse>()
                            .withOperationName("DeleteIntent").withMarshaller(new DeleteIntentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteIntentRequest));
            CompletableFuture<DeleteIntentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex
     * returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                            .withOperationName("DeleteResourcePolicy")
                            .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteResourcePolicyRequest));
            CompletableFuture<DeleteResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is
     * deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have
     * a policy attached, Amazon Lex returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyStatementRequest
     * @return A Java Future containing the result of the DeleteResourcePolicyStatement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcePolicyStatementResponse> deleteResourcePolicyStatement(
            DeleteResourcePolicyStatementRequest deleteResourcePolicyStatementRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteResourcePolicyStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicyStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcePolicyStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcePolicyStatementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourcePolicyStatementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyStatementRequest, DeleteResourcePolicyStatementResponse>()
                            .withOperationName("DeleteResourcePolicyStatement")
                            .withMarshaller(new DeleteResourcePolicyStatementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteResourcePolicyStatementRequest));
            CompletableFuture<DeleteResourcePolicyStatementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     *
     * @param deleteSlotRequest
     * @return A Java Future containing the result of the DeleteSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSlotResponse> deleteSlot(DeleteSlotRequest deleteSlotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteSlotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSlotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSlotRequest, DeleteSlotResponse>().withOperationName("DeleteSlot")
                            .withMarshaller(new DeleteSlotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSlotRequest));
            CompletableFuture<DeleteSlotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return A Java Future containing the result of the DeleteSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSlotTypeResponse> deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlotType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSlotTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSlotTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSlotTypeRequest, DeleteSlotTypeResponse>()
                            .withOperationName("DeleteSlotType")
                            .withMarshaller(new DeleteSlotTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSlotTypeRequest));
            CompletableFuture<DeleteSlotTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The action to delete the selected test set.
     * </p>
     *
     * @param deleteTestSetRequest
     * @return A Java Future containing the result of the DeleteTestSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTestSetResponse> deleteTestSet(DeleteTestSetRequest deleteTestSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTestSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTestSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTestSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTestSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTestSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTestSetRequest, DeleteTestSetResponse>()
                            .withOperationName("DeleteTestSet")
                            .withMarshaller(new DeleteTestSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTestSetRequest));
            CompletableFuture<DeleteTestSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes stored utterances.
     * </p>
     * <p>
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the
     * <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html">
     * ListAggregatedUtterances</a> operation, and then stored indefinitely for use in improving the ability of your bot
     * to respond to user input..
     * </p>
     * <p>
     * Use the <code>DeleteUtterances</code> operation to manually delete utterances for a specific session. When you
     * use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot's ability to respond to
     * user input are deleted immediately. Utterances stored for use with the <code>ListAggregatedUtterances</code>
     * operation are deleted after 15 days.
     * </p>
     *
     * @param deleteUtterancesRequest
     * @return A Java Future containing the result of the DeleteUtterances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUtterancesResponse> deleteUtterances(DeleteUtterancesRequest deleteUtterancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUtterancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUtterances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUtterancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUtterancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUtterancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUtterancesRequest, DeleteUtterancesResponse>()
                            .withOperationName("DeleteUtterances")
                            .withMarshaller(new DeleteUtterancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUtterancesRequest));
            CompletableFuture<DeleteUtterancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     *
     * @param describeBotRequest
     * @return A Java Future containing the result of the DescribeBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBotResponse> describeBot(DescribeBotRequest describeBotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeBotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBotRequest, DescribeBotResponse>()
                            .withOperationName("DescribeBot").withMarshaller(new DescribeBotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBotRequest));
            CompletableFuture<DescribeBotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     *
     * @param describeBotAliasRequest
     * @return A Java Future containing the result of the DescribeBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBotAliasResponse> describeBotAlias(DescribeBotAliasRequest describeBotAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBotAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBotAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBotAliasRequest, DescribeBotAliasResponse>()
                            .withOperationName("DescribeBotAlias")
                            .withMarshaller(new DescribeBotAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBotAliasRequest));
            CompletableFuture<DescribeBotAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     *
     * @param describeBotLocaleRequest
     * @return A Java Future containing the result of the DescribeBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBotLocaleResponse> describeBotLocale(DescribeBotLocaleRequest describeBotLocaleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotLocale");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBotLocaleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBotLocaleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBotLocaleRequest, DescribeBotLocaleResponse>()
                            .withOperationName("DescribeBotLocale")
                            .withMarshaller(new DescribeBotLocaleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBotLocaleRequest));
            CompletableFuture<DescribeBotLocaleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides metadata information about a bot recommendation. This information will enable you to get a description
     * on the request inputs, to download associated transcripts after processing is complete, and to download intents
     * and slot-types generated by the bot recommendation.
     * </p>
     *
     * @param describeBotRecommendationRequest
     * @return A Java Future containing the result of the DescribeBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBotRecommendationResponse> describeBotRecommendation(
            DescribeBotRecommendationRequest describeBotRecommendationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotRecommendationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotRecommendation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBotRecommendationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBotRecommendationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBotRecommendationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBotRecommendationRequest, DescribeBotRecommendationResponse>()
                            .withOperationName("DescribeBotRecommendation")
                            .withMarshaller(new DescribeBotRecommendationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBotRecommendationRequest));
            CompletableFuture<DescribeBotRecommendationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     *
     * @param describeBotVersionRequest
     * @return A Java Future containing the result of the DescribeBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBotVersionResponse> describeBotVersion(DescribeBotVersionRequest describeBotVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBotVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBotVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBotVersionRequest, DescribeBotVersionResponse>()
                            .withOperationName("DescribeBotVersion")
                            .withMarshaller(new DescribeBotVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBotVersionRequest));
            CompletableFuture<DescribeBotVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides metadata information about a custom vocabulary.
     * </p>
     *
     * @param describeCustomVocabularyMetadataRequest
     * @return A Java Future containing the result of the DescribeCustomVocabularyMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeCustomVocabularyMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomVocabularyMetadataResponse> describeCustomVocabularyMetadata(
            DescribeCustomVocabularyMetadataRequest describeCustomVocabularyMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomVocabularyMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomVocabularyMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCustomVocabularyMetadataResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeCustomVocabularyMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCustomVocabularyMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomVocabularyMetadataRequest, DescribeCustomVocabularyMetadataResponse>()
                            .withOperationName("DescribeCustomVocabularyMetadata")
                            .withMarshaller(new DescribeCustomVocabularyMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCustomVocabularyMetadataRequest));
            CompletableFuture<DescribeCustomVocabularyMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specific export.
     * </p>
     *
     * @param describeExportRequest
     * @return A Java Future containing the result of the DescribeExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeExportResponse> describeExport(DescribeExportRequest describeExportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeExportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeExportRequest, DescribeExportResponse>()
                            .withOperationName("DescribeExport")
                            .withMarshaller(new DescribeExportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeExportRequest));
            CompletableFuture<DescribeExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specific import.
     * </p>
     *
     * @param describeImportRequest
     * @return A Java Future containing the result of the DescribeImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImportResponse> describeImport(DescribeImportRequest describeImportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeImportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeImportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeImportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeImportRequest, DescribeImportResponse>()
                            .withOperationName("DescribeImport")
                            .withMarshaller(new DescribeImportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeImportRequest));
            CompletableFuture<DescribeImportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     *
     * @param describeIntentRequest
     * @return A Java Future containing the result of the DescribeIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIntentResponse> describeIntent(DescribeIntentRequest describeIntentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIntent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeIntentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeIntentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIntentRequest, DescribeIntentResponse>()
                            .withOperationName("DescribeIntent")
                            .withMarshaller(new DescribeIntentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeIntentRequest));
            CompletableFuture<DescribeIntentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the resource policy and policy revision for a bot or bot alias.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse>()
                            .withOperationName("DescribeResourcePolicy")
                            .withMarshaller(new DescribeResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeResourcePolicyRequest));
            CompletableFuture<DescribeResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     *
     * @param describeSlotRequest
     * @return A Java Future containing the result of the DescribeSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSlotResponse> describeSlot(DescribeSlotRequest describeSlotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSlot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeSlotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSlotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSlotRequest, DescribeSlotResponse>()
                            .withOperationName("DescribeSlot").withMarshaller(new DescribeSlotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSlotRequest));
            CompletableFuture<DescribeSlotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     *
     * @param describeSlotTypeRequest
     * @return A Java Future containing the result of the DescribeSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSlotTypeResponse> describeSlotType(DescribeSlotTypeRequest describeSlotTypeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSlotType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSlotTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSlotTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSlotTypeRequest, DescribeSlotTypeResponse>()
                            .withOperationName("DescribeSlotType")
                            .withMarshaller(new DescribeSlotTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSlotTypeRequest));
            CompletableFuture<DescribeSlotTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets metadata information about the test execution.
     * </p>
     *
     * @param describeTestExecutionRequest
     * @return A Java Future containing the result of the DescribeTestExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTestExecutionResponse> describeTestExecution(
            DescribeTestExecutionRequest describeTestExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTestExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTestExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTestExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTestExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTestExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTestExecutionRequest, DescribeTestExecutionResponse>()
                            .withOperationName("DescribeTestExecution")
                            .withMarshaller(new DescribeTestExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTestExecutionRequest));
            CompletableFuture<DescribeTestExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets metadata information about the test set.
     * </p>
     *
     * @param describeTestSetRequest
     * @return A Java Future containing the result of the DescribeTestSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTestSetResponse> describeTestSet(DescribeTestSetRequest describeTestSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTestSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTestSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTestSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTestSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTestSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTestSetRequest, DescribeTestSetResponse>()
                            .withOperationName("DescribeTestSet")
                            .withMarshaller(new DescribeTestSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTestSetRequest));
            CompletableFuture<DescribeTestSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets metadata information about the test set discrepancy report.
     * </p>
     *
     * @param describeTestSetDiscrepancyReportRequest
     * @return A Java Future containing the result of the DescribeTestSetDiscrepancyReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestSetDiscrepancyReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetDiscrepancyReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTestSetDiscrepancyReportResponse> describeTestSetDiscrepancyReport(
            DescribeTestSetDiscrepancyReportRequest describeTestSetDiscrepancyReportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTestSetDiscrepancyReportRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTestSetDiscrepancyReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTestSetDiscrepancyReportResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeTestSetDiscrepancyReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTestSetDiscrepancyReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTestSetDiscrepancyReportRequest, DescribeTestSetDiscrepancyReportResponse>()
                            .withOperationName("DescribeTestSetDiscrepancyReport")
                            .withMarshaller(new DescribeTestSetDiscrepancyReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTestSetDiscrepancyReportRequest));
            CompletableFuture<DescribeTestSetDiscrepancyReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets metadata information about the test set generation.
     * </p>
     *
     * @param describeTestSetGenerationRequest
     * @return A Java Future containing the result of the DescribeTestSetGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeTestSetGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTestSetGenerationResponse> describeTestSetGeneration(
            DescribeTestSetGenerationRequest describeTestSetGenerationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTestSetGenerationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTestSetGeneration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTestSetGenerationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTestSetGenerationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTestSetGenerationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTestSetGenerationRequest, DescribeTestSetGenerationResponse>()
                            .withOperationName("DescribeTestSetGeneration")
                            .withMarshaller(new DescribeTestSetGenerationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTestSetGenerationRequest));
            CompletableFuture<DescribeTestSetGenerationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URL to download the test execution result artifacts.
     * </p>
     *
     * @param getTestExecutionArtifactsUrlRequest
     * @return A Java Future containing the result of the GetTestExecutionArtifactsUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.GetTestExecutionArtifactsUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GetTestExecutionArtifactsUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTestExecutionArtifactsUrlResponse> getTestExecutionArtifactsUrl(
            GetTestExecutionArtifactsUrlRequest getTestExecutionArtifactsUrlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTestExecutionArtifactsUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTestExecutionArtifactsUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTestExecutionArtifactsUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTestExecutionArtifactsUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTestExecutionArtifactsUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTestExecutionArtifactsUrlRequest, GetTestExecutionArtifactsUrlResponse>()
                            .withOperationName("GetTestExecutionArtifactsUrl")
                            .withMarshaller(new GetTestExecutionArtifactsUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getTestExecutionArtifactsUrlRequest));
            CompletableFuture<GetTestExecutionArtifactsUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of utterances that users have sent to the bot.
     * </p>
     * <p>
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the
     * phrase "I want to order pizza" are aggregated into the same line in the response.
     * </p>
     * <p>
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly
     * recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot
     * and didn't activate an intent.
     * </p>
     * <p>
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     * </p>
     * <p>
     * Utterances statistics are not generated under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>childDirected</code> field was set to true when the bot was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are using slot obfuscation with one or more slots.
     * </p>
     * </li>
     * <li>
     * <p>
     * You opted out of participating in improving Amazon Lex.
     * </p>
     * </li>
     * </ul>
     *
     * @param listAggregatedUtterancesRequest
     * @return A Java Future containing the result of the ListAggregatedUtterances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListAggregatedUtterances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAggregatedUtterancesResponse> listAggregatedUtterances(
            ListAggregatedUtterancesRequest listAggregatedUtterancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAggregatedUtterancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAggregatedUtterances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAggregatedUtterancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAggregatedUtterancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAggregatedUtterancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAggregatedUtterancesRequest, ListAggregatedUtterancesResponse>()
                            .withOperationName("ListAggregatedUtterances")
                            .withMarshaller(new ListAggregatedUtterancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAggregatedUtterancesRequest));
            CompletableFuture<ListAggregatedUtterancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     *
     * @param listBotAliasesRequest
     * @return A Java Future containing the result of the ListBotAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBotAliasesResponse> listBotAliases(ListBotAliasesRequest listBotAliasesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBotAliasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBotAliasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBotAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBotAliasesRequest, ListBotAliasesResponse>()
                            .withOperationName("ListBotAliases")
                            .withMarshaller(new ListBotAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBotAliasesRequest));
            CompletableFuture<ListBotAliasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     *
     * @param listBotLocalesRequest
     * @return A Java Future containing the result of the ListBotLocales operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBotLocalesResponse> listBotLocales(ListBotLocalesRequest listBotLocalesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotLocalesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotLocales");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBotLocalesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBotLocalesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBotLocalesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBotLocalesRequest, ListBotLocalesResponse>()
                            .withOperationName("ListBotLocales")
                            .withMarshaller(new ListBotLocalesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBotLocalesRequest));
            CompletableFuture<ListBotLocalesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a list of bot recommendations that meet the specified criteria.
     * </p>
     *
     * @param listBotRecommendationsRequest
     * @return A Java Future containing the result of the ListBotRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBotRecommendationsResponse> listBotRecommendations(
            ListBotRecommendationsRequest listBotRecommendationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBotRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBotRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBotRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBotRecommendationsRequest, ListBotRecommendationsResponse>()
                            .withOperationName("ListBotRecommendations")
                            .withMarshaller(new ListBotRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBotRecommendationsRequest));
            CompletableFuture<ListBotRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     *
     * @param listBotVersionsRequest
     * @return A Java Future containing the result of the ListBotVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBotVersionsResponse> listBotVersions(ListBotVersionsRequest listBotVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBotVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBotVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBotVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBotVersionsRequest, ListBotVersionsResponse>()
                            .withOperationName("ListBotVersions")
                            .withMarshaller(new ListBotVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBotVersionsRequest));
            CompletableFuture<ListBotVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     *
     * @param listBotsRequest
     * @return A Java Future containing the result of the ListBots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListBotsResponse> listBots(ListBotsRequest listBotsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListBotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBotsRequest, ListBotsResponse>().withOperationName("ListBots")
                            .withMarshaller(new ListBotsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBotsRequest));
            CompletableFuture<ListBotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return A Java Future containing the result of the ListBuiltInIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBuiltInIntentsResponse> listBuiltInIntents(ListBuiltInIntentsRequest listBuiltInIntentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuiltInIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuiltInIntents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBuiltInIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBuiltInIntentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBuiltInIntentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBuiltInIntentsRequest, ListBuiltInIntentsResponse>()
                            .withOperationName("ListBuiltInIntents")
                            .withMarshaller(new ListBuiltInIntentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBuiltInIntentsRequest));
            CompletableFuture<ListBuiltInIntentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return A Java Future containing the result of the ListBuiltInSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBuiltInSlotTypesResponse> listBuiltInSlotTypes(
            ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuiltInSlotTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuiltInSlotTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBuiltInSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBuiltInSlotTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBuiltInSlotTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBuiltInSlotTypesRequest, ListBuiltInSlotTypesResponse>()
                            .withOperationName("ListBuiltInSlotTypes")
                            .withMarshaller(new ListBuiltInSlotTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBuiltInSlotTypesRequest));
            CompletableFuture<ListBuiltInSlotTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
     * </p>
     *
     * @param listCustomVocabularyItemsRequest
     * @return A Java Future containing the result of the ListCustomVocabularyItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListCustomVocabularyItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomVocabularyItemsResponse> listCustomVocabularyItems(
            ListCustomVocabularyItemsRequest listCustomVocabularyItemsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomVocabularyItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomVocabularyItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomVocabularyItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomVocabularyItemsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomVocabularyItemsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomVocabularyItemsRequest, ListCustomVocabularyItemsResponse>()
                            .withOperationName("ListCustomVocabularyItems")
                            .withMarshaller(new ListCustomVocabularyItemsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCustomVocabularyItemsRequest));
            CompletableFuture<ListCustomVocabularyItemsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     * </p>
     *
     * @param listExportsRequest
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListExportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListExportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListExportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListExportsRequest, ListExportsResponse>()
                            .withOperationName("ListExports").withMarshaller(new ListExportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listExportsRequest));
            CompletableFuture<ListExportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListImportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListImportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImportsRequest, ListImportsResponse>()
                            .withOperationName("ListImports").withMarshaller(new ListImportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listImportsRequest));
            CompletableFuture<ListImportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves summary metrics for the intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html"
     * >AnalyticsIntentMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can specify
     * only one <code>order</code> in a given request.
     * </p>
     *
     * @param listIntentMetricsRequest
     * @return A Java Future containing the result of the ListIntentMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIntentMetricsResponse> listIntentMetrics(ListIntentMetricsRequest listIntentMetricsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntentMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntentMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIntentMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIntentMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIntentMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIntentMetricsRequest, ListIntentMetricsResponse>()
                            .withOperationName("ListIntentMetrics")
                            .withMarshaller(new ListIntentMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listIntentMetricsRequest));
            CompletableFuture<ListIntentMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following
     * fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>intentPath</code> – Define an order of intents for which you want to retrieve metrics. Separate intents in
     * the path with a forward slash. For example, populate the <code>intentPath</code> field with
     * <code>/BookCar/BookHotel</code> to see details about how many times users invoked the <code>BookCar</code> and
     * <code>BookHotel</code> intents in that order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the optional <code>filters</code> field to filter the results.
     * </p>
     *
     * @param listIntentPathsRequest
     * @return A Java Future containing the result of the ListIntentPaths operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentPaths
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentPaths" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIntentPathsResponse> listIntentPaths(ListIntentPathsRequest listIntentPathsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntentPathsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntentPaths");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIntentPathsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIntentPathsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIntentPathsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIntentPathsRequest, ListIntentPathsResponse>()
                            .withOperationName("ListIntentPaths")
                            .withMarshaller(new ListIntentPathsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listIntentPathsRequest));
            CompletableFuture<ListIntentPathsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html"
     * >AnalyticsIntentStageMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can only
     * specify one <code>order</code> in a given request.
     * </p>
     *
     * @param listIntentStageMetricsRequest
     * @return A Java Future containing the result of the ListIntentStageMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntentStageMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntentStageMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIntentStageMetricsResponse> listIntentStageMetrics(
            ListIntentStageMetricsRequest listIntentStageMetricsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntentStageMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntentStageMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIntentStageMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIntentStageMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIntentStageMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIntentStageMetricsRequest, ListIntentStageMetricsResponse>()
                            .withOperationName("ListIntentStageMetrics")
                            .withMarshaller(new ListIntentStageMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listIntentStageMetricsRequest));
            CompletableFuture<ListIntentStageMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     *
     * @param listIntentsRequest
     * @return A Java Future containing the result of the ListIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListIntentsResponse> listIntents(ListIntentsRequest listIntentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIntentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListIntentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIntentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIntentsRequest, ListIntentsResponse>()
                            .withOperationName("ListIntents").withMarshaller(new ListIntentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listIntentsRequest));
            CompletableFuture<ListIntentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in
     * the response are ordered by relevance.
     * </p>
     *
     * @param listRecommendedIntentsRequest
     * @return A Java Future containing the result of the ListRecommendedIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListRecommendedIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecommendedIntentsResponse> listRecommendedIntents(
            ListRecommendedIntentsRequest listRecommendedIntentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecommendedIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecommendedIntents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecommendedIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRecommendedIntentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRecommendedIntentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecommendedIntentsRequest, ListRecommendedIntentsResponse>()
                            .withOperationName("ListRecommendedIntents")
                            .withMarshaller(new ListRecommendedIntentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listRecommendedIntentsRequest));
            CompletableFuture<ListRecommendedIntentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of metadata for individual user sessions with your bot. The <code>startDateTime</code> and
     * <code>endDateTime</code> fields are required. These fields define a time range for which you want to retrieve
     * results. Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     *
     * @param listSessionAnalyticsDataRequest
     * @return A Java Future containing the result of the ListSessionAnalyticsData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSessionAnalyticsDataResponse> listSessionAnalyticsData(
            ListSessionAnalyticsDataRequest listSessionAnalyticsDataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionAnalyticsDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessionAnalyticsData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSessionAnalyticsDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSessionAnalyticsDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSessionAnalyticsDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSessionAnalyticsDataRequest, ListSessionAnalyticsDataResponse>()
                            .withOperationName("ListSessionAnalyticsData")
                            .withMarshaller(new ListSessionAnalyticsDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSessionAnalyticsDataRequest));
            CompletableFuture<ListSessionAnalyticsDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves summary metrics for the user sessions with your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html"
     * >AnalyticsSessionMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     *
     * @param listSessionMetricsRequest
     * @return A Java Future containing the result of the ListSessionMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSessionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSessionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSessionMetricsResponse> listSessionMetrics(ListSessionMetricsRequest listSessionMetricsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessionMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSessionMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSessionMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSessionMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSessionMetricsRequest, ListSessionMetricsResponse>()
                            .withOperationName("ListSessionMetrics")
                            .withMarshaller(new ListSessionMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSessionMetricsRequest));
            CompletableFuture<ListSessionMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     *
     * @param listSlotTypesRequest
     * @return A Java Future containing the result of the ListSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSlotTypesResponse> listSlotTypes(ListSlotTypesRequest listSlotTypesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSlotTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSlotTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSlotTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSlotTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSlotTypesRequest, ListSlotTypesResponse>()
                            .withOperationName("ListSlotTypes")
                            .withMarshaller(new ListSlotTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSlotTypesRequest));
            CompletableFuture<ListSlotTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     *
     * @param listSlotsRequest
     * @return A Java Future containing the result of the ListSlots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSlotsResponse> listSlots(ListSlotsRequest listSlotsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSlotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSlots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSlotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSlotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSlotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSlotsRequest, ListSlotsResponse>().withOperationName("ListSlots")
                            .withMarshaller(new ListSlotsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSlotsRequest));
            CompletableFuture<ListSlotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of test execution result items.
     * </p>
     *
     * @param listTestExecutionResultItemsRequest
     * @return A Java Future containing the result of the ListTestExecutionResultItems operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutionResultItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTestExecutionResultItemsResponse> listTestExecutionResultItems(
            ListTestExecutionResultItemsRequest listTestExecutionResultItemsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestExecutionResultItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestExecutionResultItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTestExecutionResultItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTestExecutionResultItemsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTestExecutionResultItemsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTestExecutionResultItemsRequest, ListTestExecutionResultItemsResponse>()
                            .withOperationName("ListTestExecutionResultItems")
                            .withMarshaller(new ListTestExecutionResultItemsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTestExecutionResultItemsRequest));
            CompletableFuture<ListTestExecutionResultItemsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The list of test set executions.
     * </p>
     *
     * @param listTestExecutionsRequest
     * @return A Java Future containing the result of the ListTestExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTestExecutionsResponse> listTestExecutions(ListTestExecutionsRequest listTestExecutionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTestExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTestExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTestExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTestExecutionsRequest, ListTestExecutionsResponse>()
                            .withOperationName("ListTestExecutions")
                            .withMarshaller(new ListTestExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTestExecutionsRequest));
            CompletableFuture<ListTestExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The list of test set records.
     * </p>
     *
     * @param listTestSetRecordsRequest
     * @return A Java Future containing the result of the ListTestSetRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSetRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTestSetRecordsResponse> listTestSetRecords(ListTestSetRecordsRequest listTestSetRecordsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestSetRecordsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestSetRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTestSetRecordsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTestSetRecordsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTestSetRecordsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTestSetRecordsRequest, ListTestSetRecordsResponse>()
                            .withOperationName("ListTestSetRecords")
                            .withMarshaller(new ListTestSetRecordsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTestSetRecordsRequest));
            CompletableFuture<ListTestSetRecordsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The list of the test sets
     * </p>
     *
     * @param listTestSetsRequest
     * @return A Java Future containing the result of the ListTestSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTestSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTestSetsResponse> listTestSets(ListTestSetsRequest listTestSetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTestSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTestSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTestSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTestSetsRequest, ListTestSetsResponse>()
                            .withOperationName("ListTestSets").withMarshaller(new ListTestSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTestSetsRequest));
            CompletableFuture<ListTestSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values
     * by which to sort the results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     *
     * @param listUtteranceAnalyticsDataRequest
     * @return A Java Future containing the result of the ListUtteranceAnalyticsData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceAnalyticsData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceAnalyticsData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUtteranceAnalyticsDataResponse> listUtteranceAnalyticsData(
            ListUtteranceAnalyticsDataRequest listUtteranceAnalyticsDataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUtteranceAnalyticsDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUtteranceAnalyticsData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUtteranceAnalyticsDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUtteranceAnalyticsDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUtteranceAnalyticsDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUtteranceAnalyticsDataRequest, ListUtteranceAnalyticsDataResponse>()
                            .withOperationName("ListUtteranceAnalyticsData")
                            .withMarshaller(new ListUtteranceAnalyticsDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUtteranceAnalyticsDataRequest));
            CompletableFuture<ListUtteranceAnalyticsDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * To use this API operation, your IAM role must have permissions to perform the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html"
     * >ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a>
     * for the IAM policy to apply to the IAM role.
     * </p>
     * </note>
     * <p>
     * Retrieves summary metrics for the utterances in your bot. The following fields are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>metrics</code> – A list of <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html"
     * >AnalyticsUtteranceMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to
     * calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>,
     * <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the
     * results in <code>Ascending</code> or <code>Descending</code> order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Of the optional fields, you can organize the results in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by
     * which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the
     * results.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>maxResults</code> field to limit the number of results to return in a single response and the
     * <code>nextToken</code> field to return the next batch of results if the response does not return the full set of
     * results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you
     * can specify it in either field, but not in both.
     * </p>
     *
     * @param listUtteranceMetricsRequest
     * @return A Java Future containing the result of the ListUtteranceMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListUtteranceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListUtteranceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUtteranceMetricsResponse> listUtteranceMetrics(
            ListUtteranceMetricsRequest listUtteranceMetricsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUtteranceMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUtteranceMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUtteranceMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUtteranceMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUtteranceMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUtteranceMetricsRequest, ListUtteranceMetricsResponse>()
                            .withOperationName("ListUtteranceMetrics")
                            .withMarshaller(new ListUtteranceMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUtteranceMetricsRequest));
            CompletableFuture<ListUtteranceMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Search for associated transcripts that meet the specified criteria.
     * </p>
     *
     * @param searchAssociatedTranscriptsRequest
     * @return A Java Future containing the result of the SearchAssociatedTranscripts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.SearchAssociatedTranscripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchAssociatedTranscriptsResponse> searchAssociatedTranscripts(
            SearchAssociatedTranscriptsRequest searchAssociatedTranscriptsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchAssociatedTranscriptsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchAssociatedTranscripts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchAssociatedTranscriptsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchAssociatedTranscriptsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchAssociatedTranscriptsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchAssociatedTranscriptsRequest, SearchAssociatedTranscriptsResponse>()
                            .withOperationName("SearchAssociatedTranscripts")
                            .withMarshaller(new SearchAssociatedTranscriptsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchAssociatedTranscriptsRequest));
            CompletableFuture<SearchAssociatedTranscriptsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this to provide your transcript data, and to start the bot recommendation process.
     * </p>
     *
     * @param startBotRecommendationRequest
     * @return A Java Future containing the result of the StartBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartBotRecommendationResponse> startBotRecommendation(
            StartBotRecommendationRequest startBotRecommendationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startBotRecommendationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBotRecommendation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartBotRecommendationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartBotRecommendationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartBotRecommendationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartBotRecommendationRequest, StartBotRecommendationResponse>()
                            .withOperationName("StartBotRecommendation")
                            .withMarshaller(new StartBotRecommendationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startBotRecommendationRequest));
            CompletableFuture<StartBotRecommendationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     * </p>
     *
     * @param startImportRequest
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartImportResponse> startImport(StartImportRequest startImportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartImportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartImportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartImportRequest, StartImportResponse>()
                            .withOperationName("StartImport").withMarshaller(new StartImportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startImportRequest));
            CompletableFuture<StartImportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The action to start test set execution.
     * </p>
     *
     * @param startTestExecutionRequest
     * @return A Java Future containing the result of the StartTestExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartTestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTestExecutionResponse> startTestExecution(StartTestExecutionRequest startTestExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTestExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTestExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTestExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartTestExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartTestExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTestExecutionRequest, StartTestExecutionResponse>()
                            .withOperationName("StartTestExecution")
                            .withMarshaller(new StartTestExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startTestExecutionRequest));
            CompletableFuture<StartTestExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The action to start the generation of test set.
     * </p>
     *
     * @param startTestSetGenerationRequest
     * @return A Java Future containing the result of the StartTestSetGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StartTestSetGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestSetGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTestSetGenerationResponse> startTestSetGeneration(
            StartTestSetGenerationRequest startTestSetGenerationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTestSetGenerationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTestSetGeneration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTestSetGenerationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartTestSetGenerationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartTestSetGenerationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTestSetGenerationRequest, StartTestSetGenerationResponse>()
                            .withOperationName("StartTestSetGeneration")
                            .withMarshaller(new StartTestSetGenerationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startTestSetGenerationRequest));
            CompletableFuture<StartTestSetGenerationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stop an already running Bot Recommendation request.
     * </p>
     *
     * @param stopBotRecommendationRequest
     * @return A Java Future containing the result of the StopBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.StopBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopBotRecommendationResponse> stopBotRecommendation(
            StopBotRecommendationRequest stopBotRecommendationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopBotRecommendationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopBotRecommendation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopBotRecommendationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopBotRecommendationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopBotRecommendationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopBotRecommendationRequest, StopBotRecommendationResponse>()
                            .withOperationName("StopBotRecommendation")
                            .withMarshaller(new StopBotRecommendationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopBotRecommendationRequest));
            CompletableFuture<StopBotRecommendationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     *
     * @param updateBotRequest
     * @return A Java Future containing the result of the UpdateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBotResponse> updateBot(UpdateBotRequest updateBotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateBotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBotRequest, UpdateBotResponse>().withOperationName("UpdateBot")
                            .withMarshaller(new UpdateBotRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBotRequest));
            CompletableFuture<UpdateBotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     *
     * @param updateBotAliasRequest
     * @return A Java Future containing the result of the UpdateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBotAliasResponse> updateBotAlias(UpdateBotAliasRequest updateBotAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBotAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBotAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBotAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBotAliasRequest, UpdateBotAliasResponse>()
                            .withOperationName("UpdateBotAlias")
                            .withMarshaller(new UpdateBotAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateBotAliasRequest));
            CompletableFuture<UpdateBotAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     *
     * @param updateBotLocaleRequest
     * @return A Java Future containing the result of the UpdateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBotLocaleResponse> updateBotLocale(UpdateBotLocaleRequest updateBotLocaleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBotLocale");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBotLocaleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBotLocaleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBotLocaleRequest, UpdateBotLocaleResponse>()
                            .withOperationName("UpdateBotLocale")
                            .withMarshaller(new UpdateBotLocaleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateBotLocaleRequest));
            CompletableFuture<UpdateBotLocaleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing bot recommendation request.
     * </p>
     *
     * @param updateBotRecommendationRequest
     * @return A Java Future containing the result of the UpdateBotRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBotRecommendationResponse> updateBotRecommendation(
            UpdateBotRecommendationRequest updateBotRecommendationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotRecommendationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBotRecommendation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBotRecommendationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBotRecommendationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBotRecommendationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBotRecommendationRequest, UpdateBotRecommendationResponse>()
                            .withOperationName("UpdateBotRecommendation")
                            .withMarshaller(new UpdateBotRecommendationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateBotRecommendationRequest));
            CompletableFuture<UpdateBotRecommendationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the password used to protect an export zip archive.
     * </p>
     * <p>
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not
     * protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">DescribeExport</a>
     * operation.
     * </p>
     *
     * @param updateExportRequest
     * @return A Java Future containing the result of the UpdateExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateExportResponse> updateExport(UpdateExportRequest updateExportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateExportRequest, UpdateExportResponse>()
                            .withOperationName("UpdateExport").withMarshaller(new UpdateExportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateExportRequest));
            CompletableFuture<UpdateExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     *
     * @param updateIntentRequest
     * @return A Java Future containing the result of the UpdateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIntentResponse> updateIntent(UpdateIntentRequest updateIntentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateIntentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIntentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIntentRequest, UpdateIntentResponse>()
                            .withOperationName("UpdateIntent").withMarshaller(new UpdateIntentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateIntentRequest));
            CompletableFuture<UpdateIntentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon
     * Lex returns an exception.
     * </p>
     *
     * @param updateResourcePolicyRequest
     * @return A Java Future containing the result of the UpdateResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You asked to describe a resource that doesn't exist. Check the resource
     *         that you are requesting and try again.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourcePolicyResponse> updateResourcePolicy(
            UpdateResourcePolicyRequest updateResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourcePolicyRequest, UpdateResourcePolicyResponse>()
                            .withOperationName("UpdateResourcePolicy")
                            .withMarshaller(new UpdateResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateResourcePolicyRequest));
            CompletableFuture<UpdateResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     *
     * @param updateSlotRequest
     * @return A Java Future containing the result of the UpdateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSlotResponse> updateSlot(UpdateSlotRequest updateSlotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSlot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateSlotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSlotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSlotRequest, UpdateSlotResponse>().withOperationName("UpdateSlot")
                            .withMarshaller(new UpdateSlotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSlotRequest));
            CompletableFuture<UpdateSlotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     *
     * @param updateSlotTypeRequest
     * @return A Java Future containing the result of the UpdateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSlotTypeResponse> updateSlotType(UpdateSlotTypeRequest updateSlotTypeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSlotType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSlotTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSlotTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSlotTypeRequest, UpdateSlotTypeResponse>()
                            .withOperationName("UpdateSlotType")
                            .withMarshaller(new UpdateSlotTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSlotTypeRequest));
            CompletableFuture<UpdateSlotTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The action to update the test set.
     * </p>
     *
     * @param updateTestSetRequest
     * @return A Java Future containing the result of the UpdateTestSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Your request rate is too high. Reduce the frequency of requests.</li>
     *         <li>ServiceQuotaExceededException You have reached a quota for your bot.</li>
     *         <li>ValidationException One of the input parameters in your request isn't valid. Check the parameters and
     *         try your request again.</li>
     *         <li>PreconditionFailedException Your request couldn't be completed because one or more request fields
     *         aren't valid. Check the fields in your request and try again.</li>
     *         <li>ConflictException The action that you tried to perform couldn't be completed because the resource is
     *         in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request
     *         again.</li>
     *         <li>InternalServerException The service encountered an unexpected condition. Try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateTestSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateTestSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTestSetResponse> updateTestSet(UpdateTestSetRequest updateTestSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTestSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTestSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTestSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateTestSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTestSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTestSetRequest, UpdateTestSetResponse>()
                            .withOperationName("UpdateTestSet")
                            .withMarshaller(new UpdateTestSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateTestSetRequest));
            CompletableFuture<UpdateTestSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public LexModelsV2AsyncWaiter waiter() {
        return LexModelsV2AsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final LexModelsV2ServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LexModelsV2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailedException")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
