/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.DataPrivacy;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBotVersionResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DescribeBotVersionResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::botId)).setter(DescribeBotVersionResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::botName)).setter(DescribeBotVersionResponse.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::botVersion)).setter(DescribeBotVersionResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::description)).setter(DescribeBotVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::roleArn)).setter(DescribeBotVersionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataPrivacy").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::dataPrivacy)).setter(DescribeBotVersionResponse.setter(Builder::dataPrivacy)).constructor(DataPrivacy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::idleSessionTTLInSeconds)).setter(DescribeBotVersionResponse.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botStatus").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::botStatusAsString)).setter(DescribeBotVersionResponse.setter(Builder::botStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::failureReasons)).setter(DescribeBotVersionResponse.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DescribeBotVersionResponse.getter(DescribeBotVersionResponse::creationDateTime)).setter(DescribeBotVersionResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD, BOT_VERSION_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, BOT_STATUS_FIELD, FAILURE_REASONS_FIELD, CREATION_DATE_TIME_FIELD));
    private final String botId;
    private final String botName;
    private final String botVersion;
    private final String description;
    private final String roleArn;
    private final DataPrivacy dataPrivacy;
    private final Integer idleSessionTTLInSeconds;
    private final String botStatus;
    private final List<String> failureReasons;
    private final Instant creationDateTime;

    private DescribeBotVersionResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botName = builder.botName;
        this.botVersion = builder.botVersion;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.botStatus = builder.botStatus;
        this.failureReasons = builder.failureReasons;
        this.creationDateTime = builder.creationDateTime;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botName() {
        return this.botName;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String description() {
        return this.description;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final DataPrivacy dataPrivacy() {
        return this.dataPrivacy;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final BotStatus botStatus() {
        return BotStatus.fromValue(this.botStatus);
    }

    public final String botStatusAsString() {
        return this.botStatus;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotVersionResponse)) {
            return false;
        }
        DescribeBotVersionResponse other = (DescribeBotVersionResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.dataPrivacy(), other.dataPrivacy()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.botStatusAsString(), other.botStatusAsString()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.creationDateTime(), other.creationDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBotVersionResponse").add("BotId", (Object)this.botId()).add("BotName", (Object)this.botName()).add("BotVersion", (Object)this.botVersion()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).add("DataPrivacy", (Object)this.dataPrivacy()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("BotStatus", (Object)this.botStatusAsString()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("CreationDateTime", (Object)this.creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "dataPrivacy": {
                return Optional.ofNullable(clazz.cast(this.dataPrivacy()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "botStatus": {
                return Optional.ofNullable(clazz.cast(this.botStatusAsString()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotVersionResponse, T> g) {
        return obj -> g.apply((DescribeBotVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botName;
        private String botVersion;
        private String description;
        private String roleArn;
        private DataPrivacy dataPrivacy;
        private Integer idleSessionTTLInSeconds;
        private String botStatus;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotVersionResponse model) {
            super(model);
            this.botId(model.botId);
            this.botName(model.botName);
            this.botVersion(model.botVersion);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.dataPrivacy(model.dataPrivacy);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.botStatus(model.botStatus);
            this.failureReasons(model.failureReasons);
            this.creationDateTime(model.creationDateTime);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotName() {
            return this.botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return this.dataPrivacy != null ? this.dataPrivacy.toBuilder() : null;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getBotStatus() {
            return this.botStatus;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public DescribeBotVersionResponse build() {
            return new DescribeBotVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBotVersionResponse> {
        public Builder botId(String var1);

        public Builder botName(String var1);

        public Builder botVersion(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder dataPrivacy(DataPrivacy var1);

        default public Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return this.dataPrivacy((DataPrivacy)((DataPrivacy.Builder)DataPrivacy.builder().applyMutation(dataPrivacy)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder botStatus(String var1);

        public Builder botStatus(BotStatus var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder creationDateTime(Instant var1);
    }
}

