/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse;

public class GetTableObjectsPublisher
implements SdkPublisher<GetTableObjectsResponse> {
    private final LakeFormationAsyncClient client;
    private final GetTableObjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTableObjectsPublisher(LakeFormationAsyncClient client, GetTableObjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTableObjectsPublisher(LakeFormationAsyncClient client, GetTableObjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTableObjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTableObjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetTableObjectsResponseFetcher
    implements AsyncPageFetcher<GetTableObjectsResponse> {
        private GetTableObjectsResponseFetcher() {
        }

        public boolean hasNextPage(GetTableObjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTableObjectsResponse> nextPage(GetTableObjectsResponse previousPage) {
            if (previousPage == null) {
                return GetTableObjectsPublisher.this.client.getTableObjects(GetTableObjectsPublisher.this.firstRequest);
            }
            return GetTableObjectsPublisher.this.client.getTableObjects((GetTableObjectsRequest)((Object)GetTableObjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

