/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataLakeResourceType {
    CATALOG("CATALOG"),
    DATABASE("DATABASE"),
    TABLE("TABLE"),
    DATA_LOCATION("DATA_LOCATION"),
    LF_TAG("LF_TAG"),
    LF_TAG_POLICY("LF_TAG_POLICY"),
    LF_TAG_POLICY_DATABASE("LF_TAG_POLICY_DATABASE"),
    LF_TAG_POLICY_TABLE("LF_TAG_POLICY_TABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataLakeResourceType> VALUE_MAP;
    private final String value;

    private DataLakeResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataLakeResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataLakeResourceType> knownValues() {
        EnumSet<DataLakeResourceType> knownValues = EnumSet.allOf(DataLakeResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataLakeResourceType.class, DataLakeResourceType::toString);
    }
}

