/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitRange;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitRangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkUnitsResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, GetWorkUnitsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetWorkUnitsResponse.getter(GetWorkUnitsResponse::nextToken)).setter(GetWorkUnitsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(GetWorkUnitsResponse.getter(GetWorkUnitsResponse::queryId)).setter(GetWorkUnitsResponse.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<List<WorkUnitRange>> WORK_UNIT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkUnitRanges").getter(GetWorkUnitsResponse.getter(GetWorkUnitsResponse::workUnitRanges)).setter(GetWorkUnitsResponse.setter(Builder::workUnitRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkUnitRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, QUERY_ID_FIELD, WORK_UNIT_RANGES_FIELD));
    private final String nextToken;
    private final String queryId;
    private final List<WorkUnitRange> workUnitRanges;

    private GetWorkUnitsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.queryId = builder.queryId;
        this.workUnitRanges = builder.workUnitRanges;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final boolean hasWorkUnitRanges() {
        return this.workUnitRanges != null && !(this.workUnitRanges instanceof SdkAutoConstructList);
    }

    public final List<WorkUnitRange> workUnitRanges() {
        return this.workUnitRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkUnitRanges() ? this.workUnitRanges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkUnitsResponse)) {
            return false;
        }
        GetWorkUnitsResponse other = (GetWorkUnitsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.queryId(), other.queryId()) && this.hasWorkUnitRanges() == other.hasWorkUnitRanges() && Objects.equals(this.workUnitRanges(), other.workUnitRanges());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkUnitsResponse").add("NextToken", (Object)this.nextToken()).add("QueryId", (Object)this.queryId()).add("WorkUnitRanges", this.hasWorkUnitRanges() ? this.workUnitRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "WorkUnitRanges": {
                return Optional.ofNullable(clazz.cast(this.workUnitRanges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkUnitsResponse, T> g) {
        return obj -> g.apply((GetWorkUnitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String queryId;
        private List<WorkUnitRange> workUnitRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkUnitsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.queryId(model.queryId);
            this.workUnitRanges(model.workUnitRanges);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final List<WorkUnitRange.Builder> getWorkUnitRanges() {
            List<WorkUnitRange.Builder> result = WorkUnitRangeListCopier.copyToBuilder(this.workUnitRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkUnitRanges(Collection<WorkUnitRange.BuilderImpl> workUnitRanges) {
            this.workUnitRanges = WorkUnitRangeListCopier.copyFromBuilder(workUnitRanges);
        }

        @Override
        public final Builder workUnitRanges(Collection<WorkUnitRange> workUnitRanges) {
            this.workUnitRanges = WorkUnitRangeListCopier.copy(workUnitRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workUnitRanges(WorkUnitRange ... workUnitRanges) {
            this.workUnitRanges(Arrays.asList(workUnitRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workUnitRanges(Consumer<WorkUnitRange.Builder> ... workUnitRanges) {
            this.workUnitRanges(Stream.of(workUnitRanges).map(c -> (WorkUnitRange)((WorkUnitRange.Builder)WorkUnitRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetWorkUnitsResponse build() {
            return new GetWorkUnitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkUnitsResponse> {
        public Builder nextToken(String var1);

        public Builder queryId(String var1);

        public Builder workUnitRanges(Collection<WorkUnitRange> var1);

        public Builder workUnitRanges(WorkUnitRange ... var1);

        public Builder workUnitRanges(Consumer<WorkUnitRange.Builder> ... var1);
    }
}

