/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataLakeResourceType {
    CATALOG("CATALOG"),
    DATABASE("DATABASE"),
    TABLE("TABLE"),
    DATA_LOCATION("DATA_LOCATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataLakeResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataLakeResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataLakeResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataLakeResourceType> knownValues() {
        return Stream.of(DataLakeResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

