/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyManagerType {
    AWS("AWS"),
    CUSTOMER("CUSTOMER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyManagerType> VALUE_MAP;
    private final String value;

    private KeyManagerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyManagerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyManagerType> knownValues() {
        EnumSet<KeyManagerType> knownValues = EnumSet.allOf(KeyManagerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyManagerType.class, KeyManagerType::toString);
    }
}

