/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideosignaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIceServerConfigResponse extends KinesisVideoSignalingResponse implements
        ToCopyableBuilder<GetIceServerConfigResponse.Builder, GetIceServerConfigResponse> {
    private static final SdkField<List<IceServer>> ICE_SERVER_LIST_FIELD = SdkField
            .<List<IceServer>> builder(MarshallingType.LIST)
            .memberName("IceServerList")
            .getter(getter(GetIceServerConfigResponse::iceServerList))
            .setter(setter(Builder::iceServerList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IceServerList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IceServer> builder(MarshallingType.SDK_POJO)
                                            .constructor(IceServer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICE_SERVER_LIST_FIELD));

    private final List<IceServer> iceServerList;

    private GetIceServerConfigResponse(BuilderImpl builder) {
        super(builder);
        this.iceServerList = builder.iceServerList;
    }

    /**
     * For responses, this returns true if the service returned a value for the IceServerList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIceServerList() {
        return iceServerList != null && !(iceServerList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of ICE server information objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIceServerList} method.
     * </p>
     * 
     * @return The list of ICE server information objects.
     */
    public final List<IceServer> iceServerList() {
        return iceServerList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIceServerList() ? iceServerList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIceServerConfigResponse)) {
            return false;
        }
        GetIceServerConfigResponse other = (GetIceServerConfigResponse) obj;
        return hasIceServerList() == other.hasIceServerList() && Objects.equals(iceServerList(), other.iceServerList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIceServerConfigResponse").add("IceServerList", hasIceServerList() ? iceServerList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IceServerList":
            return Optional.ofNullable(clazz.cast(iceServerList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIceServerConfigResponse, T> g) {
        return obj -> g.apply((GetIceServerConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoSignalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIceServerConfigResponse> {
        /**
         * <p>
         * The list of ICE server information objects.
         * </p>
         * 
         * @param iceServerList
         *        The list of ICE server information objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iceServerList(Collection<IceServer> iceServerList);

        /**
         * <p>
         * The list of ICE server information objects.
         * </p>
         * 
         * @param iceServerList
         *        The list of ICE server information objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iceServerList(IceServer... iceServerList);

        /**
         * <p>
         * The list of ICE server information objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisvideosignaling.model.IceServer.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kinesisvideosignaling.model.IceServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisvideosignaling.model.IceServer.Builder#build()} is called
         * immediately and its result is passed to {@link #iceServerList(List<IceServer>)}.
         * 
         * @param iceServerList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisvideosignaling.model.IceServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iceServerList(java.util.Collection<IceServer>)
         */
        Builder iceServerList(Consumer<IceServer.Builder>... iceServerList);
    }

    static final class BuilderImpl extends KinesisVideoSignalingResponse.BuilderImpl implements Builder {
        private List<IceServer> iceServerList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIceServerConfigResponse model) {
            super(model);
            iceServerList(model.iceServerList);
        }

        public final List<IceServer.Builder> getIceServerList() {
            List<IceServer.Builder> result = IceServerListCopier.copyToBuilder(this.iceServerList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIceServerList(Collection<IceServer.BuilderImpl> iceServerList) {
            this.iceServerList = IceServerListCopier.copyFromBuilder(iceServerList);
        }

        @Override
        public final Builder iceServerList(Collection<IceServer> iceServerList) {
            this.iceServerList = IceServerListCopier.copy(iceServerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iceServerList(IceServer... iceServerList) {
            iceServerList(Arrays.asList(iceServerList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iceServerList(Consumer<IceServer.Builder>... iceServerList) {
            iceServerList(Stream.of(iceServerList).map(c -> IceServer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetIceServerConfigResponse build() {
            return new GetIceServerConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
