/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideosignaling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideosignaling.model.IceServer;
import software.amazon.awssdk.services.kinesisvideosignaling.model.IceServerListCopier;
import software.amazon.awssdk.services.kinesisvideosignaling.model.KinesisVideoSignalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIceServerConfigResponse
extends KinesisVideoSignalingResponse
implements ToCopyableBuilder<Builder, GetIceServerConfigResponse> {
    private static final SdkField<List<IceServer>> ICE_SERVER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IceServerList").getter(GetIceServerConfigResponse.getter(GetIceServerConfigResponse::iceServerList)).setter(GetIceServerConfigResponse.setter(Builder::iceServerList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IceServerList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IceServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICE_SERVER_LIST_FIELD));
    private final List<IceServer> iceServerList;

    private GetIceServerConfigResponse(BuilderImpl builder) {
        super(builder);
        this.iceServerList = builder.iceServerList;
    }

    public final boolean hasIceServerList() {
        return this.iceServerList != null && !(this.iceServerList instanceof SdkAutoConstructList);
    }

    public final List<IceServer> iceServerList() {
        return this.iceServerList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIceServerList() ? this.iceServerList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIceServerConfigResponse)) {
            return false;
        }
        GetIceServerConfigResponse other = (GetIceServerConfigResponse)((Object)obj);
        return this.hasIceServerList() == other.hasIceServerList() && Objects.equals(this.iceServerList(), other.iceServerList());
    }

    public final String toString() {
        return ToString.builder((String)"GetIceServerConfigResponse").add("IceServerList", this.hasIceServerList() ? this.iceServerList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IceServerList": {
                return Optional.ofNullable(clazz.cast(this.iceServerList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIceServerConfigResponse, T> g) {
        return obj -> g.apply((GetIceServerConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoSignalingResponse.BuilderImpl
    implements Builder {
        private List<IceServer> iceServerList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIceServerConfigResponse model) {
            super(model);
            this.iceServerList(model.iceServerList);
        }

        public final List<IceServer.Builder> getIceServerList() {
            List<IceServer.Builder> result = IceServerListCopier.copyToBuilder(this.iceServerList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIceServerList(Collection<IceServer.BuilderImpl> iceServerList) {
            this.iceServerList = IceServerListCopier.copyFromBuilder(iceServerList);
        }

        @Override
        @Transient
        public final Builder iceServerList(Collection<IceServer> iceServerList) {
            this.iceServerList = IceServerListCopier.copy(iceServerList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder iceServerList(IceServer ... iceServerList) {
            this.iceServerList(Arrays.asList(iceServerList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder iceServerList(Consumer<IceServer.Builder> ... iceServerList) {
            this.iceServerList(Stream.of(iceServerList).map(c -> (IceServer)((IceServer.Builder)IceServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetIceServerConfigResponse build() {
            return new GetIceServerConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoSignalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIceServerConfigResponse> {
        public Builder iceServerList(Collection<IceServer> var1);

        public Builder iceServerList(IceServer ... var1);

        public Builder iceServerList(Consumer<IceServer.Builder> ... var1);
    }
}

