/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoResponse;
import software.amazon.awssdk.services.kinesisvideo.model.MediaStorageConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMediaStorageConfigurationResponse
extends KinesisVideoResponse
implements ToCopyableBuilder<Builder, DescribeMediaStorageConfigurationResponse> {
    private static final SdkField<MediaStorageConfiguration> MEDIA_STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaStorageConfiguration").getter(DescribeMediaStorageConfigurationResponse.getter(DescribeMediaStorageConfigurationResponse::mediaStorageConfiguration)).setter(DescribeMediaStorageConfigurationResponse.setter(Builder::mediaStorageConfiguration)).constructor(MediaStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStorageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_STORAGE_CONFIGURATION_FIELD));
    private final MediaStorageConfiguration mediaStorageConfiguration;

    private DescribeMediaStorageConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.mediaStorageConfiguration = builder.mediaStorageConfiguration;
    }

    public final MediaStorageConfiguration mediaStorageConfiguration() {
        return this.mediaStorageConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStorageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMediaStorageConfigurationResponse)) {
            return false;
        }
        DescribeMediaStorageConfigurationResponse other = (DescribeMediaStorageConfigurationResponse)((Object)obj);
        return Objects.equals(this.mediaStorageConfiguration(), other.mediaStorageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMediaStorageConfigurationResponse").add("MediaStorageConfiguration", (Object)this.mediaStorageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaStorageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mediaStorageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMediaStorageConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeMediaStorageConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoResponse.BuilderImpl
    implements Builder {
        private MediaStorageConfiguration mediaStorageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMediaStorageConfigurationResponse model) {
            super(model);
            this.mediaStorageConfiguration(model.mediaStorageConfiguration);
        }

        public final MediaStorageConfiguration.Builder getMediaStorageConfiguration() {
            return this.mediaStorageConfiguration != null ? this.mediaStorageConfiguration.toBuilder() : null;
        }

        public final void setMediaStorageConfiguration(MediaStorageConfiguration.BuilderImpl mediaStorageConfiguration) {
            this.mediaStorageConfiguration = mediaStorageConfiguration != null ? mediaStorageConfiguration.build() : null;
        }

        @Override
        public final Builder mediaStorageConfiguration(MediaStorageConfiguration mediaStorageConfiguration) {
            this.mediaStorageConfiguration = mediaStorageConfiguration;
            return this;
        }

        @Override
        public DescribeMediaStorageConfigurationResponse build() {
            return new DescribeMediaStorageConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMediaStorageConfigurationResponse> {
        public Builder mediaStorageConfiguration(MediaStorageConfiguration var1);

        default public Builder mediaStorageConfiguration(Consumer<MediaStorageConfiguration.Builder> mediaStorageConfiguration) {
            return this.mediaStorageConfiguration((MediaStorageConfiguration)((MediaStorageConfiguration.Builder)MediaStorageConfiguration.builder().applyMutation(mediaStorageConfiguration)).build());
        }
    }
}

