/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details that include the maximum size of the media (<code>MaxLocalMediaSizeInMB</code>) that you
 * want to store for a stream on the Edge Agent, as well as the strategy that should be used (
 * <code>StrategyOnFullSize</code>) when a stream's maximum size has been reached.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalSizeConfig implements SdkPojo, Serializable, ToCopyableBuilder<LocalSizeConfig.Builder, LocalSizeConfig> {
    private static final SdkField<Integer> MAX_LOCAL_MEDIA_SIZE_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxLocalMediaSizeInMB").getter(getter(LocalSizeConfig::maxLocalMediaSizeInMB))
            .setter(setter(Builder::maxLocalMediaSizeInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLocalMediaSizeInMB").build())
            .build();

    private static final SdkField<String> STRATEGY_ON_FULL_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StrategyOnFullSize").getter(getter(LocalSizeConfig::strategyOnFullSizeAsString))
            .setter(setter(Builder::strategyOnFullSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrategyOnFullSize").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_LOCAL_MEDIA_SIZE_IN_MB_FIELD, STRATEGY_ON_FULL_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxLocalMediaSizeInMB;

    private final String strategyOnFullSize;

    private LocalSizeConfig(BuilderImpl builder) {
        this.maxLocalMediaSizeInMB = builder.maxLocalMediaSizeInMB;
        this.strategyOnFullSize = builder.strategyOnFullSize;
    }

    /**
     * <p>
     * The overall maximum size of the media that you want to store for a stream on the Edge Agent.
     * </p>
     * 
     * @return The overall maximum size of the media that you want to store for a stream on the Edge Agent.
     */
    public final Integer maxLocalMediaSizeInMB() {
        return maxLocalMediaSizeInMB;
    }

    /**
     * <p>
     * The strategy to perform when a stream’s <code>MaxLocalMediaSizeInMB</code> limit is reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #strategyOnFullSize} will return {@link StrategyOnFullSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #strategyOnFullSizeAsString}.
     * </p>
     * 
     * @return The strategy to perform when a stream’s <code>MaxLocalMediaSizeInMB</code> limit is reached.
     * @see StrategyOnFullSize
     */
    public final StrategyOnFullSize strategyOnFullSize() {
        return StrategyOnFullSize.fromValue(strategyOnFullSize);
    }

    /**
     * <p>
     * The strategy to perform when a stream’s <code>MaxLocalMediaSizeInMB</code> limit is reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #strategyOnFullSize} will return {@link StrategyOnFullSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #strategyOnFullSizeAsString}.
     * </p>
     * 
     * @return The strategy to perform when a stream’s <code>MaxLocalMediaSizeInMB</code> limit is reached.
     * @see StrategyOnFullSize
     */
    public final String strategyOnFullSizeAsString() {
        return strategyOnFullSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxLocalMediaSizeInMB());
        hashCode = 31 * hashCode + Objects.hashCode(strategyOnFullSizeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalSizeConfig)) {
            return false;
        }
        LocalSizeConfig other = (LocalSizeConfig) obj;
        return Objects.equals(maxLocalMediaSizeInMB(), other.maxLocalMediaSizeInMB())
                && Objects.equals(strategyOnFullSizeAsString(), other.strategyOnFullSizeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LocalSizeConfig").add("MaxLocalMediaSizeInMB", maxLocalMediaSizeInMB())
                .add("StrategyOnFullSize", strategyOnFullSizeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxLocalMediaSizeInMB":
            return Optional.ofNullable(clazz.cast(maxLocalMediaSizeInMB()));
        case "StrategyOnFullSize":
            return Optional.ofNullable(clazz.cast(strategyOnFullSizeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalSizeConfig, T> g) {
        return obj -> g.apply((LocalSizeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalSizeConfig> {
        /**
         * <p>
         * The overall maximum size of the media that you want to store for a stream on the Edge Agent.
         * </p>
         * 
         * @param maxLocalMediaSizeInMB
         *        The overall maximum size of the media that you want to store for a stream on the Edge Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLocalMediaSizeInMB(Integer maxLocalMediaSizeInMB);

        /**
         * <p>
         * The strategy to perform when a stream’s <code>MaxLocalMediaSizeInMB</code> limit is reached.
         * </p>
         * 
         * @param strategyOnFullSize
         *        The strategy to perform when a stream’s <code>MaxLocalMediaSizeInMB</code> limit is reached.
         * @see StrategyOnFullSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StrategyOnFullSize
         */
        Builder strategyOnFullSize(String strategyOnFullSize);

        /**
         * <p>
         * The strategy to perform when a stream’s <code>MaxLocalMediaSizeInMB</code> limit is reached.
         * </p>
         * 
         * @param strategyOnFullSize
         *        The strategy to perform when a stream’s <code>MaxLocalMediaSizeInMB</code> limit is reached.
         * @see StrategyOnFullSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StrategyOnFullSize
         */
        Builder strategyOnFullSize(StrategyOnFullSize strategyOnFullSize);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxLocalMediaSizeInMB;

        private String strategyOnFullSize;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalSizeConfig model) {
            maxLocalMediaSizeInMB(model.maxLocalMediaSizeInMB);
            strategyOnFullSize(model.strategyOnFullSize);
        }

        public final Integer getMaxLocalMediaSizeInMB() {
            return maxLocalMediaSizeInMB;
        }

        public final void setMaxLocalMediaSizeInMB(Integer maxLocalMediaSizeInMB) {
            this.maxLocalMediaSizeInMB = maxLocalMediaSizeInMB;
        }

        @Override
        public final Builder maxLocalMediaSizeInMB(Integer maxLocalMediaSizeInMB) {
            this.maxLocalMediaSizeInMB = maxLocalMediaSizeInMB;
            return this;
        }

        public final String getStrategyOnFullSize() {
            return strategyOnFullSize;
        }

        public final void setStrategyOnFullSize(String strategyOnFullSize) {
            this.strategyOnFullSize = strategyOnFullSize;
        }

        @Override
        public final Builder strategyOnFullSize(String strategyOnFullSize) {
            this.strategyOnFullSize = strategyOnFullSize;
            return this;
        }

        @Override
        public final Builder strategyOnFullSize(StrategyOnFullSize strategyOnFullSize) {
            this.strategyOnFullSize(strategyOnFullSize == null ? null : strategyOnFullSize.toString());
            return this;
        }

        @Override
        public LocalSizeConfig build() {
            return new LocalSizeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
