/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageGenerationConfigurationResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<DescribeImageGenerationConfigurationResponse.Builder, DescribeImageGenerationConfigurationResponse> {
    private static final SdkField<ImageGenerationConfiguration> IMAGE_GENERATION_CONFIGURATION_FIELD = SdkField
            .<ImageGenerationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ImageGenerationConfiguration")
            .getter(getter(DescribeImageGenerationConfigurationResponse::imageGenerationConfiguration))
            .setter(setter(Builder::imageGenerationConfiguration))
            .constructor(ImageGenerationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageGenerationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IMAGE_GENERATION_CONFIGURATION_FIELD));

    private final ImageGenerationConfiguration imageGenerationConfiguration;

    private DescribeImageGenerationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.imageGenerationConfiguration = builder.imageGenerationConfiguration;
    }

    /**
     * <p>
     * The structure that contains the information required for the Kinesis video stream (KVS) images delivery. If this
     * structure is null, the configuration will be deleted from the stream.
     * </p>
     * 
     * @return The structure that contains the information required for the Kinesis video stream (KVS) images delivery.
     *         If this structure is null, the configuration will be deleted from the stream.
     */
    public final ImageGenerationConfiguration imageGenerationConfiguration() {
        return imageGenerationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageGenerationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageGenerationConfigurationResponse)) {
            return false;
        }
        DescribeImageGenerationConfigurationResponse other = (DescribeImageGenerationConfigurationResponse) obj;
        return Objects.equals(imageGenerationConfiguration(), other.imageGenerationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageGenerationConfigurationResponse")
                .add("ImageGenerationConfiguration", imageGenerationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageGenerationConfiguration":
            return Optional.ofNullable(clazz.cast(imageGenerationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageGenerationConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeImageGenerationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeImageGenerationConfigurationResponse> {
        /**
         * <p>
         * The structure that contains the information required for the Kinesis video stream (KVS) images delivery. If
         * this structure is null, the configuration will be deleted from the stream.
         * </p>
         * 
         * @param imageGenerationConfiguration
         *        The structure that contains the information required for the Kinesis video stream (KVS) images
         *        delivery. If this structure is null, the configuration will be deleted from the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageGenerationConfiguration(ImageGenerationConfiguration imageGenerationConfiguration);

        /**
         * <p>
         * The structure that contains the information required for the Kinesis video stream (KVS) images delivery. If
         * this structure is null, the configuration will be deleted from the stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageGenerationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageGenerationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageGenerationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #imageGenerationConfiguration(ImageGenerationConfiguration)}.
         * 
         * @param imageGenerationConfiguration
         *        a consumer that will call methods on {@link ImageGenerationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageGenerationConfiguration(ImageGenerationConfiguration)
         */
        default Builder imageGenerationConfiguration(Consumer<ImageGenerationConfiguration.Builder> imageGenerationConfiguration) {
            return imageGenerationConfiguration(ImageGenerationConfiguration.builder()
                    .applyMutation(imageGenerationConfiguration).build());
        }
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private ImageGenerationConfiguration imageGenerationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageGenerationConfigurationResponse model) {
            super(model);
            imageGenerationConfiguration(model.imageGenerationConfiguration);
        }

        public final ImageGenerationConfiguration.Builder getImageGenerationConfiguration() {
            return imageGenerationConfiguration != null ? imageGenerationConfiguration.toBuilder() : null;
        }

        public final void setImageGenerationConfiguration(ImageGenerationConfiguration.BuilderImpl imageGenerationConfiguration) {
            this.imageGenerationConfiguration = imageGenerationConfiguration != null ? imageGenerationConfiguration.build()
                    : null;
        }

        @Override
        public final Builder imageGenerationConfiguration(ImageGenerationConfiguration imageGenerationConfiguration) {
            this.imageGenerationConfiguration = imageGenerationConfiguration;
            return this;
        }

        @Override
        public DescribeImageGenerationConfigurationResponse build() {
            return new DescribeImageGenerationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
