/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordsResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, PutRecordsResponse> {
    private static final SdkField<Integer> FAILED_RECORD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedRecordCount").getter(PutRecordsResponse.getter(PutRecordsResponse::failedRecordCount)).setter(PutRecordsResponse.setter(Builder::failedRecordCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRecordCount").build()}).build();
    private static final SdkField<List<PutRecordsResultEntry>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(PutRecordsResponse.getter(PutRecordsResponse::records)).setter(PutRecordsResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PutRecordsResultEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(PutRecordsResponse.getter(PutRecordsResponse::encryptionTypeAsString)).setter(PutRecordsResponse.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_RECORD_COUNT_FIELD, RECORDS_FIELD, ENCRYPTION_TYPE_FIELD));
    private final Integer failedRecordCount;
    private final List<PutRecordsResultEntry> records;
    private final String encryptionType;

    private PutRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.failedRecordCount = builder.failedRecordCount;
        this.records = builder.records;
        this.encryptionType = builder.encryptionType;
    }

    public final Integer failedRecordCount() {
        return this.failedRecordCount;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<PutRecordsResultEntry> records() {
        return this.records;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failedRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsResponse)) {
            return false;
        }
        PutRecordsResponse other = (PutRecordsResponse)((Object)obj);
        return Objects.equals(this.failedRecordCount(), other.failedRecordCount()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutRecordsResponse").add("FailedRecordCount", (Object)this.failedRecordCount()).add("Records", this.hasRecords() ? this.records() : null).add("EncryptionType", (Object)this.encryptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedRecordCount": {
                return Optional.ofNullable(clazz.cast(this.failedRecordCount()));
            }
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordsResponse, T> g) {
        return obj -> g.apply((PutRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private Integer failedRecordCount;
        private List<PutRecordsResultEntry> records = DefaultSdkAutoConstructList.getInstance();
        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsResponse model) {
            super(model);
            this.failedRecordCount(model.failedRecordCount);
            this.records(model.records);
            this.encryptionType(model.encryptionType);
        }

        public final Integer getFailedRecordCount() {
            return this.failedRecordCount;
        }

        public final void setFailedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
        }

        @Override
        @Transient
        public final Builder failedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
            return this;
        }

        public final List<PutRecordsResultEntry.Builder> getRecords() {
            List<PutRecordsResultEntry.Builder> result = PutRecordsResultEntryListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<PutRecordsResultEntry.BuilderImpl> records) {
            this.records = PutRecordsResultEntryListCopier.copyFromBuilder(records);
        }

        @Override
        @Transient
        public final Builder records(Collection<PutRecordsResultEntry> records) {
            this.records = PutRecordsResultEntryListCopier.copy(records);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder records(PutRecordsResultEntry ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder records(Consumer<PutRecordsResultEntry.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (PutRecordsResultEntry)((PutRecordsResultEntry.Builder)PutRecordsResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        @Transient
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        @Transient
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        @Override
        public PutRecordsResponse build() {
            return new PutRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecordsResponse> {
        public Builder failedRecordCount(Integer var1);

        public Builder records(Collection<PutRecordsResultEntry> var1);

        public Builder records(PutRecordsResultEntry ... var1);

        public Builder records(Consumer<PutRecordsResultEntry.Builder> ... var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);
    }
}

