/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute;
import software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.CollapsedResultDetail;
import software.amazon.awssdk.services.kendra.model.DocumentAttribute;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.QueryResultFormat;
import software.amazon.awssdk.services.kendra.model.QueryResultType;
import software.amazon.awssdk.services.kendra.model.ScoreAttributes;
import software.amazon.awssdk.services.kendra.model.TableExcerpt;
import software.amazon.awssdk.services.kendra.model.TextWithHighlights;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryResultItem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(QueryResultItem.getter(QueryResultItem::id)).setter(QueryResultItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(QueryResultItem.getter(QueryResultItem::typeAsString)).setter(QueryResultItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(QueryResultItem.getter(QueryResultItem::formatAsString)).setter(QueryResultItem.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<List<AdditionalResultAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalAttributes").getter(QueryResultItem.getter(QueryResultItem::additionalAttributes)).setter(QueryResultItem.setter(Builder::additionalAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalResultAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentId").getter(QueryResultItem.getter(QueryResultItem::documentId)).setter(QueryResultItem.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()}).build();
    private static final SdkField<TextWithHighlights> DOCUMENT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentTitle").getter(QueryResultItem.getter(QueryResultItem::documentTitle)).setter(QueryResultItem.setter(Builder::documentTitle)).constructor(TextWithHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitle").build()}).build();
    private static final SdkField<TextWithHighlights> DOCUMENT_EXCERPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentExcerpt").getter(QueryResultItem.getter(QueryResultItem::documentExcerpt)).setter(QueryResultItem.setter(Builder::documentExcerpt)).constructor(TextWithHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentExcerpt").build()}).build();
    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentURI").getter(QueryResultItem.getter(QueryResultItem::documentURI)).setter(QueryResultItem.setter(Builder::documentURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentURI").build()}).build();
    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentAttributes").getter(QueryResultItem.getter(QueryResultItem::documentAttributes)).setter(QueryResultItem.setter(Builder::documentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ScoreAttributes> SCORE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScoreAttributes").getter(QueryResultItem.getter(QueryResultItem::scoreAttributes)).setter(QueryResultItem.setter(Builder::scoreAttributes)).constructor(ScoreAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreAttributes").build()}).build();
    private static final SdkField<String> FEEDBACK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackToken").getter(QueryResultItem.getter(QueryResultItem::feedbackToken)).setter(QueryResultItem.setter(Builder::feedbackToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackToken").build()}).build();
    private static final SdkField<TableExcerpt> TABLE_EXCERPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TableExcerpt").getter(QueryResultItem.getter(QueryResultItem::tableExcerpt)).setter(QueryResultItem.setter(Builder::tableExcerpt)).constructor(TableExcerpt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableExcerpt").build()}).build();
    private static final SdkField<CollapsedResultDetail> COLLAPSED_RESULT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CollapsedResultDetail").getter(QueryResultItem.getter(QueryResultItem::collapsedResultDetail)).setter(QueryResultItem.setter(Builder::collapsedResultDetail)).constructor(CollapsedResultDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollapsedResultDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, FORMAT_FIELD, ADDITIONAL_ATTRIBUTES_FIELD, DOCUMENT_ID_FIELD, DOCUMENT_TITLE_FIELD, DOCUMENT_EXCERPT_FIELD, DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD, SCORE_ATTRIBUTES_FIELD, FEEDBACK_TOKEN_FIELD, TABLE_EXCERPT_FIELD, COLLAPSED_RESULT_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String format;
    private final List<AdditionalResultAttribute> additionalAttributes;
    private final String documentId;
    private final TextWithHighlights documentTitle;
    private final TextWithHighlights documentExcerpt;
    private final String documentURI;
    private final List<DocumentAttribute> documentAttributes;
    private final ScoreAttributes scoreAttributes;
    private final String feedbackToken;
    private final TableExcerpt tableExcerpt;
    private final CollapsedResultDetail collapsedResultDetail;

    private QueryResultItem(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.format = builder.format;
        this.additionalAttributes = builder.additionalAttributes;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.documentExcerpt = builder.documentExcerpt;
        this.documentURI = builder.documentURI;
        this.documentAttributes = builder.documentAttributes;
        this.scoreAttributes = builder.scoreAttributes;
        this.feedbackToken = builder.feedbackToken;
        this.tableExcerpt = builder.tableExcerpt;
        this.collapsedResultDetail = builder.collapsedResultDetail;
    }

    public final String id() {
        return this.id;
    }

    public final QueryResultType type() {
        return QueryResultType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final QueryResultFormat format() {
        return QueryResultFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final boolean hasAdditionalAttributes() {
        return this.additionalAttributes != null && !(this.additionalAttributes instanceof SdkAutoConstructList);
    }

    public final List<AdditionalResultAttribute> additionalAttributes() {
        return this.additionalAttributes;
    }

    public final String documentId() {
        return this.documentId;
    }

    public final TextWithHighlights documentTitle() {
        return this.documentTitle;
    }

    public final TextWithHighlights documentExcerpt() {
        return this.documentExcerpt;
    }

    public final String documentURI() {
        return this.documentURI;
    }

    public final boolean hasDocumentAttributes() {
        return this.documentAttributes != null && !(this.documentAttributes instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttribute> documentAttributes() {
        return this.documentAttributes;
    }

    public final ScoreAttributes scoreAttributes() {
        return this.scoreAttributes;
    }

    public final String feedbackToken() {
        return this.feedbackToken;
    }

    public final TableExcerpt tableExcerpt() {
        return this.tableExcerpt;
    }

    public final CollapsedResultDetail collapsedResultDetail() {
        return this.collapsedResultDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAttributes() ? this.additionalAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentAttributes() ? this.documentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(this.collapsedResultDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResultItem)) {
            return false;
        }
        QueryResultItem other = (QueryResultItem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.formatAsString(), other.formatAsString()) && this.hasAdditionalAttributes() == other.hasAdditionalAttributes() && Objects.equals(this.additionalAttributes(), other.additionalAttributes()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.documentTitle(), other.documentTitle()) && Objects.equals(this.documentExcerpt(), other.documentExcerpt()) && Objects.equals(this.documentURI(), other.documentURI()) && this.hasDocumentAttributes() == other.hasDocumentAttributes() && Objects.equals(this.documentAttributes(), other.documentAttributes()) && Objects.equals(this.scoreAttributes(), other.scoreAttributes()) && Objects.equals(this.feedbackToken(), other.feedbackToken()) && Objects.equals(this.tableExcerpt(), other.tableExcerpt()) && Objects.equals(this.collapsedResultDetail(), other.collapsedResultDetail());
    }

    public final String toString() {
        return ToString.builder((String)"QueryResultItem").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Format", (Object)this.formatAsString()).add("AdditionalAttributes", this.hasAdditionalAttributes() ? this.additionalAttributes() : null).add("DocumentId", (Object)this.documentId()).add("DocumentTitle", (Object)this.documentTitle()).add("DocumentExcerpt", (Object)this.documentExcerpt()).add("DocumentURI", (Object)this.documentURI()).add("DocumentAttributes", this.hasDocumentAttributes() ? this.documentAttributes() : null).add("ScoreAttributes", (Object)this.scoreAttributes()).add("FeedbackToken", (Object)this.feedbackToken()).add("TableExcerpt", (Object)this.tableExcerpt()).add("CollapsedResultDetail", (Object)this.collapsedResultDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "AdditionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "DocumentTitle": {
                return Optional.ofNullable(clazz.cast(this.documentTitle()));
            }
            case "DocumentExcerpt": {
                return Optional.ofNullable(clazz.cast(this.documentExcerpt()));
            }
            case "DocumentURI": {
                return Optional.ofNullable(clazz.cast(this.documentURI()));
            }
            case "DocumentAttributes": {
                return Optional.ofNullable(clazz.cast(this.documentAttributes()));
            }
            case "ScoreAttributes": {
                return Optional.ofNullable(clazz.cast(this.scoreAttributes()));
            }
            case "FeedbackToken": {
                return Optional.ofNullable(clazz.cast(this.feedbackToken()));
            }
            case "TableExcerpt": {
                return Optional.ofNullable(clazz.cast(this.tableExcerpt()));
            }
            case "CollapsedResultDetail": {
                return Optional.ofNullable(clazz.cast(this.collapsedResultDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResultItem, T> g) {
        return obj -> g.apply((QueryResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String format;
        private List<AdditionalResultAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();
        private String documentId;
        private TextWithHighlights documentTitle;
        private TextWithHighlights documentExcerpt;
        private String documentURI;
        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();
        private ScoreAttributes scoreAttributes;
        private String feedbackToken;
        private TableExcerpt tableExcerpt;
        private CollapsedResultDetail collapsedResultDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResultItem model) {
            this.id(model.id);
            this.type(model.type);
            this.format(model.format);
            this.additionalAttributes(model.additionalAttributes);
            this.documentId(model.documentId);
            this.documentTitle(model.documentTitle);
            this.documentExcerpt(model.documentExcerpt);
            this.documentURI(model.documentURI);
            this.documentAttributes(model.documentAttributes);
            this.scoreAttributes(model.scoreAttributes);
            this.feedbackToken(model.feedbackToken);
            this.tableExcerpt(model.tableExcerpt);
            this.collapsedResultDetail(model.collapsedResultDetail);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(QueryResultType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(QueryResultFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final List<AdditionalResultAttribute.Builder> getAdditionalAttributes() {
            List<AdditionalResultAttribute.Builder> result = AdditionalResultAttributeListCopier.copyToBuilder(this.additionalAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAttributes(Collection<AdditionalResultAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copyFromBuilder(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributes(Collection<AdditionalResultAttribute> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AdditionalResultAttribute ... additionalAttributes) {
            this.additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder> ... additionalAttributes) {
            this.additionalAttributes(Stream.of(additionalAttributes).map(c -> (AdditionalResultAttribute)((AdditionalResultAttribute.Builder)AdditionalResultAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentTitle() {
            return this.documentTitle != null ? this.documentTitle.toBuilder() : null;
        }

        public final void setDocumentTitle(TextWithHighlights.BuilderImpl documentTitle) {
            this.documentTitle = documentTitle != null ? documentTitle.build() : null;
        }

        @Override
        public final Builder documentTitle(TextWithHighlights documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentExcerpt() {
            return this.documentExcerpt != null ? this.documentExcerpt.toBuilder() : null;
        }

        public final void setDocumentExcerpt(TextWithHighlights.BuilderImpl documentExcerpt) {
            this.documentExcerpt = documentExcerpt != null ? documentExcerpt.build() : null;
        }

        @Override
        public final Builder documentExcerpt(TextWithHighlights documentExcerpt) {
            this.documentExcerpt = documentExcerpt;
            return this;
        }

        public final String getDocumentURI() {
            return this.documentURI;
        }

        public final void setDocumentURI(String documentURI) {
            this.documentURI = documentURI;
        }

        @Override
        public final Builder documentURI(String documentURI) {
            this.documentURI = documentURI;
            return this;
        }

        public final List<DocumentAttribute.Builder> getDocumentAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.documentAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute ... documentAttributes) {
            this.documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... documentAttributes) {
            this.documentAttributes(Stream.of(documentAttributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ScoreAttributes.Builder getScoreAttributes() {
            return this.scoreAttributes != null ? this.scoreAttributes.toBuilder() : null;
        }

        public final void setScoreAttributes(ScoreAttributes.BuilderImpl scoreAttributes) {
            this.scoreAttributes = scoreAttributes != null ? scoreAttributes.build() : null;
        }

        @Override
        public final Builder scoreAttributes(ScoreAttributes scoreAttributes) {
            this.scoreAttributes = scoreAttributes;
            return this;
        }

        public final String getFeedbackToken() {
            return this.feedbackToken;
        }

        public final void setFeedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
        }

        @Override
        public final Builder feedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
            return this;
        }

        public final TableExcerpt.Builder getTableExcerpt() {
            return this.tableExcerpt != null ? this.tableExcerpt.toBuilder() : null;
        }

        public final void setTableExcerpt(TableExcerpt.BuilderImpl tableExcerpt) {
            this.tableExcerpt = tableExcerpt != null ? tableExcerpt.build() : null;
        }

        @Override
        public final Builder tableExcerpt(TableExcerpt tableExcerpt) {
            this.tableExcerpt = tableExcerpt;
            return this;
        }

        public final CollapsedResultDetail.Builder getCollapsedResultDetail() {
            return this.collapsedResultDetail != null ? this.collapsedResultDetail.toBuilder() : null;
        }

        public final void setCollapsedResultDetail(CollapsedResultDetail.BuilderImpl collapsedResultDetail) {
            this.collapsedResultDetail = collapsedResultDetail != null ? collapsedResultDetail.build() : null;
        }

        @Override
        public final Builder collapsedResultDetail(CollapsedResultDetail collapsedResultDetail) {
            this.collapsedResultDetail = collapsedResultDetail;
            return this;
        }

        public QueryResultItem build() {
            return new QueryResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryResultItem> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(QueryResultType var1);

        public Builder format(String var1);

        public Builder format(QueryResultFormat var1);

        public Builder additionalAttributes(Collection<AdditionalResultAttribute> var1);

        public Builder additionalAttributes(AdditionalResultAttribute ... var1);

        public Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder> ... var1);

        public Builder documentId(String var1);

        public Builder documentTitle(TextWithHighlights var1);

        default public Builder documentTitle(Consumer<TextWithHighlights.Builder> documentTitle) {
            return this.documentTitle((TextWithHighlights)((TextWithHighlights.Builder)TextWithHighlights.builder().applyMutation(documentTitle)).build());
        }

        public Builder documentExcerpt(TextWithHighlights var1);

        default public Builder documentExcerpt(Consumer<TextWithHighlights.Builder> documentExcerpt) {
            return this.documentExcerpt((TextWithHighlights)((TextWithHighlights.Builder)TextWithHighlights.builder().applyMutation(documentExcerpt)).build());
        }

        public Builder documentURI(String var1);

        public Builder documentAttributes(Collection<DocumentAttribute> var1);

        public Builder documentAttributes(DocumentAttribute ... var1);

        public Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... var1);

        public Builder scoreAttributes(ScoreAttributes var1);

        default public Builder scoreAttributes(Consumer<ScoreAttributes.Builder> scoreAttributes) {
            return this.scoreAttributes((ScoreAttributes)((ScoreAttributes.Builder)ScoreAttributes.builder().applyMutation(scoreAttributes)).build());
        }

        public Builder feedbackToken(String var1);

        public Builder tableExcerpt(TableExcerpt var1);

        default public Builder tableExcerpt(Consumer<TableExcerpt.Builder> tableExcerpt) {
            return this.tableExcerpt((TableExcerpt)((TableExcerpt.Builder)TableExcerpt.builder().applyMutation(tableExcerpt)).build());
        }

        public Builder collapsedResultDetail(CollapsedResultDetail var1);

        default public Builder collapsedResultDetail(Consumer<CollapsedResultDetail.Builder> collapsedResultDetail) {
            return this.collapsedResultDetail((CollapsedResultDetail)((CollapsedResultDetail.Builder)CollapsedResultDetail.builder().applyMutation(collapsedResultDetail)).build());
        }
    }
}

