/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.CustomPluginRevisionSummary;
import software.amazon.awssdk.services.kafkaconnect.model.CustomPluginState;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaConnectResponse;
import software.amazon.awssdk.services.kafkaconnect.model.StateDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomPluginResponse
extends KafkaConnectResponse
implements ToCopyableBuilder<Builder, DescribeCustomPluginResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DescribeCustomPluginResponse.getter(DescribeCustomPluginResponse::creationTime)).setter(DescribeCustomPluginResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CUSTOM_PLUGIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customPluginArn").getter(DescribeCustomPluginResponse.getter(DescribeCustomPluginResponse::customPluginArn)).setter(DescribeCustomPluginResponse.setter(Builder::customPluginArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginArn").build()}).build();
    private static final SdkField<String> CUSTOM_PLUGIN_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customPluginState").getter(DescribeCustomPluginResponse.getter(DescribeCustomPluginResponse::customPluginStateAsString)).setter(DescribeCustomPluginResponse.setter(Builder::customPluginState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginState").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeCustomPluginResponse.getter(DescribeCustomPluginResponse::description)).setter(DescribeCustomPluginResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<CustomPluginRevisionSummary> LATEST_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestRevision").getter(DescribeCustomPluginResponse.getter(DescribeCustomPluginResponse::latestRevision)).setter(DescribeCustomPluginResponse.setter(Builder::latestRevision)).constructor(CustomPluginRevisionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeCustomPluginResponse.getter(DescribeCustomPluginResponse::name)).setter(DescribeCustomPluginResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<StateDescription> STATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stateDescription").getter(DescribeCustomPluginResponse.getter(DescribeCustomPluginResponse::stateDescription)).setter(DescribeCustomPluginResponse.setter(Builder::stateDescription)).constructor(StateDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, CUSTOM_PLUGIN_ARN_FIELD, CUSTOM_PLUGIN_STATE_FIELD, DESCRIPTION_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, STATE_DESCRIPTION_FIELD));
    private final Instant creationTime;
    private final String customPluginArn;
    private final String customPluginState;
    private final String description;
    private final CustomPluginRevisionSummary latestRevision;
    private final String name;
    private final StateDescription stateDescription;

    private DescribeCustomPluginResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.customPluginArn = builder.customPluginArn;
        this.customPluginState = builder.customPluginState;
        this.description = builder.description;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.stateDescription = builder.stateDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String customPluginArn() {
        return this.customPluginArn;
    }

    public final CustomPluginState customPluginState() {
        return CustomPluginState.fromValue(this.customPluginState);
    }

    public final String customPluginStateAsString() {
        return this.customPluginState;
    }

    public final String description() {
        return this.description;
    }

    public final CustomPluginRevisionSummary latestRevision() {
        return this.latestRevision;
    }

    public final String name() {
        return this.name;
    }

    public final StateDescription stateDescription() {
        return this.stateDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPluginStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomPluginResponse)) {
            return false;
        }
        DescribeCustomPluginResponse other = (DescribeCustomPluginResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.customPluginArn(), other.customPluginArn()) && Objects.equals(this.customPluginStateAsString(), other.customPluginStateAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.latestRevision(), other.latestRevision()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateDescription(), other.stateDescription());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCustomPluginResponse").add("CreationTime", (Object)this.creationTime()).add("CustomPluginArn", (Object)this.customPluginArn()).add("CustomPluginState", (Object)this.customPluginStateAsString()).add("Description", (Object)this.description()).add("LatestRevision", (Object)this.latestRevision()).add("Name", (Object)this.name()).add("StateDescription", (Object)this.stateDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "customPluginArn": {
                return Optional.ofNullable(clazz.cast(this.customPluginArn()));
            }
            case "customPluginState": {
                return Optional.ofNullable(clazz.cast(this.customPluginStateAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "latestRevision": {
                return Optional.ofNullable(clazz.cast(this.latestRevision()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "stateDescription": {
                return Optional.ofNullable(clazz.cast(this.stateDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomPluginResponse, T> g) {
        return obj -> g.apply((DescribeCustomPluginResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaConnectResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String customPluginArn;
        private String customPluginState;
        private String description;
        private CustomPluginRevisionSummary latestRevision;
        private String name;
        private StateDescription stateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomPluginResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.customPluginArn(model.customPluginArn);
            this.customPluginState(model.customPluginState);
            this.description(model.description);
            this.latestRevision(model.latestRevision);
            this.name(model.name);
            this.stateDescription(model.stateDescription);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCustomPluginArn() {
            return this.customPluginArn;
        }

        public final void setCustomPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
        }

        @Override
        public final Builder customPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
            return this;
        }

        public final String getCustomPluginState() {
            return this.customPluginState;
        }

        public final void setCustomPluginState(String customPluginState) {
            this.customPluginState = customPluginState;
        }

        @Override
        public final Builder customPluginState(String customPluginState) {
            this.customPluginState = customPluginState;
            return this;
        }

        @Override
        public final Builder customPluginState(CustomPluginState customPluginState) {
            this.customPluginState(customPluginState == null ? null : customPluginState.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CustomPluginRevisionSummary.Builder getLatestRevision() {
            return this.latestRevision != null ? this.latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(CustomPluginRevisionSummary.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        public final Builder latestRevision(CustomPluginRevisionSummary latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StateDescription.Builder getStateDescription() {
            return this.stateDescription != null ? this.stateDescription.toBuilder() : null;
        }

        public final void setStateDescription(StateDescription.BuilderImpl stateDescription) {
            this.stateDescription = stateDescription != null ? stateDescription.build() : null;
        }

        @Override
        public final Builder stateDescription(StateDescription stateDescription) {
            this.stateDescription = stateDescription;
            return this;
        }

        @Override
        public DescribeCustomPluginResponse build() {
            return new DescribeCustomPluginResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomPluginResponse> {
        public Builder creationTime(Instant var1);

        public Builder customPluginArn(String var1);

        public Builder customPluginState(String var1);

        public Builder customPluginState(CustomPluginState var1);

        public Builder description(String var1);

        public Builder latestRevision(CustomPluginRevisionSummary var1);

        default public Builder latestRevision(Consumer<CustomPluginRevisionSummary.Builder> latestRevision) {
            return this.latestRevision((CustomPluginRevisionSummary)((CustomPluginRevisionSummary.Builder)CustomPluginRevisionSummary.builder().applyMutation(latestRevision)).build());
        }

        public Builder name(String var1);

        public Builder stateDescription(StateDescription var1);

        default public Builder stateDescription(Consumer<StateDescription.Builder> stateDescription) {
            return this.stateDescription((StateDescription)((StateDescription.Builder)StateDescription.builder().applyMutation(stateDescription)).build());
        }
    }
}

