/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the scale-in policy for the connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScaleInPolicyDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ScaleInPolicyDescription.Builder, ScaleInPolicyDescription> {
    private static final SdkField<Integer> CPU_UTILIZATION_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cpuUtilizationPercentage").getter(getter(ScaleInPolicyDescription::cpuUtilizationPercentage))
            .setter(setter(Builder::cpuUtilizationPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuUtilizationPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CPU_UTILIZATION_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer cpuUtilizationPercentage;

    private ScaleInPolicyDescription(BuilderImpl builder) {
        this.cpuUtilizationPercentage = builder.cpuUtilizationPercentage;
    }

    /**
     * <p>
     * Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.
     * </p>
     * 
     * @return Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.
     */
    public final Integer cpuUtilizationPercentage() {
        return cpuUtilizationPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpuUtilizationPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScaleInPolicyDescription)) {
            return false;
        }
        ScaleInPolicyDescription other = (ScaleInPolicyDescription) obj;
        return Objects.equals(cpuUtilizationPercentage(), other.cpuUtilizationPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScaleInPolicyDescription").add("CpuUtilizationPercentage", cpuUtilizationPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpuUtilizationPercentage":
            return Optional.ofNullable(clazz.cast(cpuUtilizationPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScaleInPolicyDescription, T> g) {
        return obj -> g.apply((ScaleInPolicyDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScaleInPolicyDescription> {
        /**
         * <p>
         * Specifies the CPU utilization percentage threshold at which you want connector scale in to be triggered.
         * </p>
         * 
         * @param cpuUtilizationPercentage
         *        Specifies the CPU utilization percentage threshold at which you want connector scale in to be
         *        triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuUtilizationPercentage(Integer cpuUtilizationPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Integer cpuUtilizationPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ScaleInPolicyDescription model) {
            cpuUtilizationPercentage(model.cpuUtilizationPercentage);
        }

        public final Integer getCpuUtilizationPercentage() {
            return cpuUtilizationPercentage;
        }

        public final void setCpuUtilizationPercentage(Integer cpuUtilizationPercentage) {
            this.cpuUtilizationPercentage = cpuUtilizationPercentage;
        }

        @Override
        public final Builder cpuUtilizationPercentage(Integer cpuUtilizationPercentage) {
            this.cpuUtilizationPercentage = cpuUtilizationPercentage;
            return this;
        }

        @Override
        public ScaleInPolicyDescription build() {
            return new ScaleInPolicyDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
