/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a replicator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicatorSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicatorSummary.Builder, ReplicatorSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(ReplicatorSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(ReplicatorSummary::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<Boolean> IS_REPLICATOR_REFERENCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsReplicatorReference").getter(getter(ReplicatorSummary::isReplicatorReference))
            .setter(setter(Builder::isReplicatorReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isReplicatorReference").build())
            .build();

    private static final SdkField<List<KafkaClusterSummary>> KAFKA_CLUSTERS_SUMMARY_FIELD = SdkField
            .<List<KafkaClusterSummary>> builder(MarshallingType.LIST)
            .memberName("KafkaClustersSummary")
            .getter(getter(ReplicatorSummary::kafkaClustersSummary))
            .setter(setter(Builder::kafkaClustersSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClustersSummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KafkaClusterSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(KafkaClusterSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReplicationInfoSummary>> REPLICATION_INFO_SUMMARY_LIST_FIELD = SdkField
            .<List<ReplicationInfoSummary>> builder(MarshallingType.LIST)
            .memberName("ReplicationInfoSummaryList")
            .getter(getter(ReplicatorSummary::replicationInfoSummaryList))
            .setter(setter(Builder::replicationInfoSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationInfoSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationInfoSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationInfoSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorArn").getter(getter(ReplicatorSummary::replicatorArn)).setter(setter(Builder::replicatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorArn").build()).build();

    private static final SdkField<String> REPLICATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorName").getter(getter(ReplicatorSummary::replicatorName))
            .setter(setter(Builder::replicatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorName").build()).build();

    private static final SdkField<String> REPLICATOR_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorResourceArn").getter(getter(ReplicatorSummary::replicatorResourceArn))
            .setter(setter(Builder::replicatorResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorResourceArn").build())
            .build();

    private static final SdkField<String> REPLICATOR_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorState").getter(getter(ReplicatorSummary::replicatorStateAsString))
            .setter(setter(Builder::replicatorState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            CURRENT_VERSION_FIELD, IS_REPLICATOR_REFERENCE_FIELD, KAFKA_CLUSTERS_SUMMARY_FIELD,
            REPLICATION_INFO_SUMMARY_LIST_FIELD, REPLICATOR_ARN_FIELD, REPLICATOR_NAME_FIELD, REPLICATOR_RESOURCE_ARN_FIELD,
            REPLICATOR_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String currentVersion;

    private final Boolean isReplicatorReference;

    private final List<KafkaClusterSummary> kafkaClustersSummary;

    private final List<ReplicationInfoSummary> replicationInfoSummaryList;

    private final String replicatorArn;

    private final String replicatorName;

    private final String replicatorResourceArn;

    private final String replicatorState;

    private ReplicatorSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.currentVersion = builder.currentVersion;
        this.isReplicatorReference = builder.isReplicatorReference;
        this.kafkaClustersSummary = builder.kafkaClustersSummary;
        this.replicationInfoSummaryList = builder.replicationInfoSummaryList;
        this.replicatorArn = builder.replicatorArn;
        this.replicatorName = builder.replicatorName;
        this.replicatorResourceArn = builder.replicatorResourceArn;
        this.replicatorState = builder.replicatorState;
    }

    /**
     * <p>
     * The time the replicator was created.
     * </p>
     * 
     * @return The time the replicator was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The current version of the replicator.
     * </p>
     * 
     * @return The current version of the replicator.
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * Whether this resource is a replicator reference.
     * </p>
     * 
     * @return Whether this resource is a replicator reference.
     */
    public final Boolean isReplicatorReference() {
        return isReplicatorReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the KafkaClustersSummary property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKafkaClustersSummary() {
        return kafkaClustersSummary != null && !(kafkaClustersSummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Kafka Clusters used in setting up sources / targets for replication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKafkaClustersSummary} method.
     * </p>
     * 
     * @return Kafka Clusters used in setting up sources / targets for replication.
     */
    public final List<KafkaClusterSummary> kafkaClustersSummary() {
        return kafkaClustersSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationInfoSummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReplicationInfoSummaryList() {
        return replicationInfoSummaryList != null && !(replicationInfoSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of summarized information of replications between clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationInfoSummaryList} method.
     * </p>
     * 
     * @return A list of summarized information of replications between clusters.
     */
    public final List<ReplicationInfoSummary> replicationInfoSummaryList() {
        return replicationInfoSummaryList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicator.
     */
    public final String replicatorArn() {
        return replicatorArn;
    }

    /**
     * <p>
     * The name of the replicator.
     * </p>
     * 
     * @return The name of the replicator.
     */
    public final String replicatorName() {
        return replicatorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
     */
    public final String replicatorResourceArn() {
        return replicatorResourceArn;
    }

    /**
     * <p>
     * State of the replicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicatorState}
     * will return {@link ReplicatorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicatorStateAsString}.
     * </p>
     * 
     * @return State of the replicator.
     * @see ReplicatorState
     */
    public final ReplicatorState replicatorState() {
        return ReplicatorState.fromValue(replicatorState);
    }

    /**
     * <p>
     * State of the replicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicatorState}
     * will return {@link ReplicatorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicatorStateAsString}.
     * </p>
     * 
     * @return State of the replicator.
     * @see ReplicatorState
     */
    public final String replicatorStateAsString() {
        return replicatorState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(isReplicatorReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasKafkaClustersSummary() ? kafkaClustersSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationInfoSummaryList() ? replicationInfoSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorName());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicatorSummary)) {
            return false;
        }
        ReplicatorSummary other = (ReplicatorSummary) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(isReplicatorReference(), other.isReplicatorReference())
                && hasKafkaClustersSummary() == other.hasKafkaClustersSummary()
                && Objects.equals(kafkaClustersSummary(), other.kafkaClustersSummary())
                && hasReplicationInfoSummaryList() == other.hasReplicationInfoSummaryList()
                && Objects.equals(replicationInfoSummaryList(), other.replicationInfoSummaryList())
                && Objects.equals(replicatorArn(), other.replicatorArn())
                && Objects.equals(replicatorName(), other.replicatorName())
                && Objects.equals(replicatorResourceArn(), other.replicatorResourceArn())
                && Objects.equals(replicatorStateAsString(), other.replicatorStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicatorSummary").add("CreationTime", creationTime()).add("CurrentVersion", currentVersion())
                .add("IsReplicatorReference", isReplicatorReference())
                .add("KafkaClustersSummary", hasKafkaClustersSummary() ? kafkaClustersSummary() : null)
                .add("ReplicationInfoSummaryList", hasReplicationInfoSummaryList() ? replicationInfoSummaryList() : null)
                .add("ReplicatorArn", replicatorArn()).add("ReplicatorName", replicatorName())
                .add("ReplicatorResourceArn", replicatorResourceArn()).add("ReplicatorState", replicatorStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "IsReplicatorReference":
            return Optional.ofNullable(clazz.cast(isReplicatorReference()));
        case "KafkaClustersSummary":
            return Optional.ofNullable(clazz.cast(kafkaClustersSummary()));
        case "ReplicationInfoSummaryList":
            return Optional.ofNullable(clazz.cast(replicationInfoSummaryList()));
        case "ReplicatorArn":
            return Optional.ofNullable(clazz.cast(replicatorArn()));
        case "ReplicatorName":
            return Optional.ofNullable(clazz.cast(replicatorName()));
        case "ReplicatorResourceArn":
            return Optional.ofNullable(clazz.cast(replicatorResourceArn()));
        case "ReplicatorState":
            return Optional.ofNullable(clazz.cast(replicatorStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicatorSummary, T> g) {
        return obj -> g.apply((ReplicatorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicatorSummary> {
        /**
         * <p>
         * The time the replicator was created.
         * </p>
         * 
         * @param creationTime
         *        The time the replicator was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The current version of the replicator.
         * </p>
         * 
         * @param currentVersion
         *        The current version of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * Whether this resource is a replicator reference.
         * </p>
         * 
         * @param isReplicatorReference
         *        Whether this resource is a replicator reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isReplicatorReference(Boolean isReplicatorReference);

        /**
         * <p>
         * Kafka Clusters used in setting up sources / targets for replication.
         * </p>
         * 
         * @param kafkaClustersSummary
         *        Kafka Clusters used in setting up sources / targets for replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClustersSummary(Collection<KafkaClusterSummary> kafkaClustersSummary);

        /**
         * <p>
         * Kafka Clusters used in setting up sources / targets for replication.
         * </p>
         * 
         * @param kafkaClustersSummary
         *        Kafka Clusters used in setting up sources / targets for replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClustersSummary(KafkaClusterSummary... kafkaClustersSummary);

        /**
         * <p>
         * Kafka Clusters used in setting up sources / targets for replication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.KafkaClusterSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kafka.model.KafkaClusterSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.KafkaClusterSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #kafkaClustersSummary(List<KafkaClusterSummary>)}.
         * 
         * @param kafkaClustersSummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.KafkaClusterSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaClustersSummary(java.util.Collection<KafkaClusterSummary>)
         */
        Builder kafkaClustersSummary(Consumer<KafkaClusterSummary.Builder>... kafkaClustersSummary);

        /**
         * <p>
         * A list of summarized information of replications between clusters.
         * </p>
         * 
         * @param replicationInfoSummaryList
         *        A list of summarized information of replications between clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInfoSummaryList(Collection<ReplicationInfoSummary> replicationInfoSummaryList);

        /**
         * <p>
         * A list of summarized information of replications between clusters.
         * </p>
         * 
         * @param replicationInfoSummaryList
         *        A list of summarized information of replications between clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInfoSummaryList(ReplicationInfoSummary... replicationInfoSummaryList);

        /**
         * <p>
         * A list of summarized information of replications between clusters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationInfoSummaryList(List<ReplicationInfoSummary>)}.
         * 
         * @param replicationInfoSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationInfoSummaryList(java.util.Collection<ReplicationInfoSummary>)
         */
        Builder replicationInfoSummaryList(Consumer<ReplicationInfoSummary.Builder>... replicationInfoSummaryList);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replicator.
         * </p>
         * 
         * @param replicatorArn
         *        The Amazon Resource Name (ARN) of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorArn(String replicatorArn);

        /**
         * <p>
         * The name of the replicator.
         * </p>
         * 
         * @param replicatorName
         *        The name of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorName(String replicatorName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
         * </p>
         * 
         * @param replicatorResourceArn
         *        The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorResourceArn(String replicatorResourceArn);

        /**
         * <p>
         * State of the replicator.
         * </p>
         * 
         * @param replicatorState
         *        State of the replicator.
         * @see ReplicatorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicatorState
         */
        Builder replicatorState(String replicatorState);

        /**
         * <p>
         * State of the replicator.
         * </p>
         * 
         * @param replicatorState
         *        State of the replicator.
         * @see ReplicatorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicatorState
         */
        Builder replicatorState(ReplicatorState replicatorState);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String currentVersion;

        private Boolean isReplicatorReference;

        private List<KafkaClusterSummary> kafkaClustersSummary = DefaultSdkAutoConstructList.getInstance();

        private List<ReplicationInfoSummary> replicationInfoSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String replicatorArn;

        private String replicatorName;

        private String replicatorResourceArn;

        private String replicatorState;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicatorSummary model) {
            creationTime(model.creationTime);
            currentVersion(model.currentVersion);
            isReplicatorReference(model.isReplicatorReference);
            kafkaClustersSummary(model.kafkaClustersSummary);
            replicationInfoSummaryList(model.replicationInfoSummaryList);
            replicatorArn(model.replicatorArn);
            replicatorName(model.replicatorName);
            replicatorResourceArn(model.replicatorResourceArn);
            replicatorState(model.replicatorState);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final Boolean getIsReplicatorReference() {
            return isReplicatorReference;
        }

        public final void setIsReplicatorReference(Boolean isReplicatorReference) {
            this.isReplicatorReference = isReplicatorReference;
        }

        @Override
        public final Builder isReplicatorReference(Boolean isReplicatorReference) {
            this.isReplicatorReference = isReplicatorReference;
            return this;
        }

        public final List<KafkaClusterSummary.Builder> getKafkaClustersSummary() {
            List<KafkaClusterSummary.Builder> result = ___listOfKafkaClusterSummaryCopier
                    .copyToBuilder(this.kafkaClustersSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKafkaClustersSummary(Collection<KafkaClusterSummary.BuilderImpl> kafkaClustersSummary) {
            this.kafkaClustersSummary = ___listOfKafkaClusterSummaryCopier.copyFromBuilder(kafkaClustersSummary);
        }

        @Override
        public final Builder kafkaClustersSummary(Collection<KafkaClusterSummary> kafkaClustersSummary) {
            this.kafkaClustersSummary = ___listOfKafkaClusterSummaryCopier.copy(kafkaClustersSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClustersSummary(KafkaClusterSummary... kafkaClustersSummary) {
            kafkaClustersSummary(Arrays.asList(kafkaClustersSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClustersSummary(Consumer<KafkaClusterSummary.Builder>... kafkaClustersSummary) {
            kafkaClustersSummary(Stream.of(kafkaClustersSummary).map(c -> KafkaClusterSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReplicationInfoSummary.Builder> getReplicationInfoSummaryList() {
            List<ReplicationInfoSummary.Builder> result = ___listOfReplicationInfoSummaryCopier
                    .copyToBuilder(this.replicationInfoSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationInfoSummaryList(Collection<ReplicationInfoSummary.BuilderImpl> replicationInfoSummaryList) {
            this.replicationInfoSummaryList = ___listOfReplicationInfoSummaryCopier.copyFromBuilder(replicationInfoSummaryList);
        }

        @Override
        public final Builder replicationInfoSummaryList(Collection<ReplicationInfoSummary> replicationInfoSummaryList) {
            this.replicationInfoSummaryList = ___listOfReplicationInfoSummaryCopier.copy(replicationInfoSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoSummaryList(ReplicationInfoSummary... replicationInfoSummaryList) {
            replicationInfoSummaryList(Arrays.asList(replicationInfoSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoSummaryList(Consumer<ReplicationInfoSummary.Builder>... replicationInfoSummaryList) {
            replicationInfoSummaryList(Stream.of(replicationInfoSummaryList)
                    .map(c -> ReplicationInfoSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReplicatorArn() {
            return replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        public final String getReplicatorName() {
            return replicatorName;
        }

        public final void setReplicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
        }

        @Override
        public final Builder replicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
            return this;
        }

        public final String getReplicatorResourceArn() {
            return replicatorResourceArn;
        }

        public final void setReplicatorResourceArn(String replicatorResourceArn) {
            this.replicatorResourceArn = replicatorResourceArn;
        }

        @Override
        public final Builder replicatorResourceArn(String replicatorResourceArn) {
            this.replicatorResourceArn = replicatorResourceArn;
            return this;
        }

        public final String getReplicatorState() {
            return replicatorState;
        }

        public final void setReplicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
        }

        @Override
        public final Builder replicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
            return this;
        }

        @Override
        public final Builder replicatorState(ReplicatorState replicatorState) {
            this.replicatorState(replicatorState == null ? null : replicatorState.toString());
            return this;
        }

        @Override
        public ReplicatorSummary build() {
            return new ReplicatorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
