/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest;
import software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse;
import software.amazon.awssdk.services.kafka.model.VpcConnection;

public class ListVpcConnectionsPublisher
implements SdkPublisher<ListVpcConnectionsResponse> {
    private final KafkaAsyncClient client;
    private final ListVpcConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVpcConnectionsPublisher(KafkaAsyncClient client, ListVpcConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVpcConnectionsPublisher(KafkaAsyncClient client, ListVpcConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVpcConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVpcConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VpcConnection> vpcConnections() {
        Function<ListVpcConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcConnections() != null) {
                return response.vpcConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVpcConnectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVpcConnectionsResponseFetcher
    implements AsyncPageFetcher<ListVpcConnectionsResponse> {
        private ListVpcConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVpcConnectionsResponse> nextPage(ListVpcConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcConnectionsPublisher.this.client.listVpcConnections(ListVpcConnectionsPublisher.this.firstRequest);
            }
            return ListVpcConnectionsPublisher.this.client.listVpcConnections((ListVpcConnectionsRequest)((Object)ListVpcConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

