/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.model.Cluster;
import software.amazon.awssdk.services.kafka.model.ListClustersV2Request;
import software.amazon.awssdk.services.kafka.model.ListClustersV2Response;

public class ListClustersV2Iterable
implements SdkIterable<ListClustersV2Response> {
    private final KafkaClient client;
    private final ListClustersV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClustersV2Iterable(KafkaClient client, ListClustersV2Request firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListClustersV2ResponseFetcher();
    }

    public Iterator<ListClustersV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Cluster> clusterInfoList() {
        Function<ListClustersV2Response, Iterator> getIterator = response -> {
            if (response != null && response.clusterInfoList() != null) {
                return response.clusterInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClustersV2ResponseFetcher
    implements SyncPageFetcher<ListClustersV2Response> {
        private ListClustersV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListClustersV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClustersV2Response nextPage(ListClustersV2Response previousPage) {
            if (previousPage == null) {
                return ListClustersV2Iterable.this.client.listClustersV2(ListClustersV2Iterable.this.firstRequest);
            }
            return ListClustersV2Iterable.this.client.listClustersV2((ListClustersV2Request)((Object)ListClustersV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

