/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest;
import software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse;
import software.amazon.awssdk.services.kafka.model.VpcConnection;

public class ListVpcConnectionsIterable
implements SdkIterable<ListVpcConnectionsResponse> {
    private final KafkaClient client;
    private final ListVpcConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVpcConnectionsIterable(KafkaClient client, ListVpcConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVpcConnectionsResponseFetcher();
    }

    public Iterator<ListVpcConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VpcConnection> vpcConnections() {
        Function<ListVpcConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcConnections() != null) {
                return response.vpcConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVpcConnectionsResponseFetcher
    implements SyncPageFetcher<ListVpcConnectionsResponse> {
        private ListVpcConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVpcConnectionsResponse nextPage(ListVpcConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcConnectionsIterable.this.client.listVpcConnections(ListVpcConnectionsIterable.this.firstRequest);
            }
            return ListVpcConnectionsIterable.this.client.listVpcConnections((ListVpcConnectionsRequest)((Object)ListVpcConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

