/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.CloudWatchLogs;
import software.amazon.awssdk.services.kafka.model.Firehose;
import software.amazon.awssdk.services.kafka.model.S3;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerLogs
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerLogs> {
    private static final SdkField<CloudWatchLogs> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLogs").getter(BrokerLogs.getter(BrokerLogs::cloudWatchLogs)).setter(BrokerLogs.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<Firehose> FIREHOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Firehose").getter(BrokerLogs.getter(BrokerLogs::firehose)).setter(BrokerLogs.setter(Builder::firehose)).constructor(Firehose::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()}).build();
    private static final SdkField<S3> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3").getter(BrokerLogs.getter(BrokerLogs::s3)).setter(BrokerLogs.setter(Builder::s3)).constructor(S3::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD, FIREHOSE_FIELD, S3_FIELD));
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogs cloudWatchLogs;
    private final Firehose firehose;
    private final S3 s3;

    private BrokerLogs(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.firehose = builder.firehose;
        this.s3 = builder.s3;
    }

    public final CloudWatchLogs cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final Firehose firehose() {
        return this.firehose;
    }

    public final S3 s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehose());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerLogs)) {
            return false;
        }
        BrokerLogs other = (BrokerLogs)obj;
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.firehose(), other.firehose()) && Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"BrokerLogs").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("Firehose", (Object)this.firehose()).add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "Firehose": {
                return Optional.ofNullable(clazz.cast(this.firehose()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerLogs, T> g) {
        return obj -> g.apply((BrokerLogs)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogs cloudWatchLogs;
        private Firehose firehose;
        private S3 s3;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerLogs model) {
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.firehose(model.firehose);
            this.s3(model.s3);
        }

        public final CloudWatchLogs.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogs.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogs cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final Firehose.Builder getFirehose() {
            return this.firehose != null ? this.firehose.toBuilder() : null;
        }

        public final void setFirehose(Firehose.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        @Override
        public final Builder firehose(Firehose firehose) {
            this.firehose = firehose;
            return this;
        }

        public final S3.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3 s3) {
            this.s3 = s3;
            return this;
        }

        public BrokerLogs build() {
            return new BrokerLogs(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerLogs> {
        public Builder cloudWatchLogs(CloudWatchLogs var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogs.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogs)((CloudWatchLogs.Builder)CloudWatchLogs.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder firehose(Firehose var1);

        default public Builder firehose(Consumer<Firehose.Builder> firehose) {
            return this.firehose((Firehose)((Firehose.Builder)Firehose.builder().applyMutation(firehose)).build());
        }

        public Builder s3(S3 var1);

        default public Builder s3(Consumer<S3.Builder> s3) {
            return this.s3((S3)((S3.Builder)S3.builder().applyMutation(s3)).build());
        }
    }
}

