/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.model.ClusterOperationInfo;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse;

public class ListClusterOperationsIterable
implements SdkIterable<ListClusterOperationsResponse> {
    private final KafkaClient client;
    private final ListClusterOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClusterOperationsIterable(KafkaClient client, ListClusterOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListClusterOperationsResponseFetcher();
    }

    public Iterator<ListClusterOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterOperationInfo> clusterOperationInfoList() {
        Function<ListClusterOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterOperationInfoList() != null) {
                return response.clusterOperationInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClusterOperationsResponseFetcher
    implements SyncPageFetcher<ListClusterOperationsResponse> {
        private ListClusterOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClusterOperationsResponse nextPage(ListClusterOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterOperationsIterable.this.client.listClusterOperations(ListClusterOperationsIterable.this.firstRequest);
            }
            return ListClusterOperationsIterable.this.client.listClusterOperations((ListClusterOperationsRequest)((Object)ListClusterOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

