/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.ClusterOperationInfo;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.___listOfClusterOperationInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClusterOperationsResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, ListClusterOperationsResponse> {
    private static final SdkField<List<ClusterOperationInfo>> CLUSTER_OPERATION_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterOperationInfoList").getter(ListClusterOperationsResponse.getter(ListClusterOperationsResponse::clusterOperationInfoList)).setter(ListClusterOperationsResponse.setter(Builder::clusterOperationInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterOperationInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterOperationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClusterOperationsResponse.getter(ListClusterOperationsResponse::nextToken)).setter(ListClusterOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_OPERATION_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ClusterOperationInfo> clusterOperationInfoList;
    private final String nextToken;

    private ListClusterOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.clusterOperationInfoList = builder.clusterOperationInfoList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClusterOperationInfoList() {
        return this.clusterOperationInfoList != null && !(this.clusterOperationInfoList instanceof SdkAutoConstructList);
    }

    public final List<ClusterOperationInfo> clusterOperationInfoList() {
        return this.clusterOperationInfoList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterOperationInfoList() ? this.clusterOperationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterOperationsResponse)) {
            return false;
        }
        ListClusterOperationsResponse other = (ListClusterOperationsResponse)((Object)obj);
        return this.hasClusterOperationInfoList() == other.hasClusterOperationInfoList() && Objects.equals(this.clusterOperationInfoList(), other.clusterOperationInfoList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClusterOperationsResponse").add("ClusterOperationInfoList", this.hasClusterOperationInfoList() ? this.clusterOperationInfoList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterOperationInfoList": {
                return Optional.ofNullable(clazz.cast(this.clusterOperationInfoList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClusterOperationsResponse, T> g) {
        return obj -> g.apply((ListClusterOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private List<ClusterOperationInfo> clusterOperationInfoList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterOperationsResponse model) {
            super(model);
            this.clusterOperationInfoList(model.clusterOperationInfoList);
            this.nextToken(model.nextToken);
        }

        public final Collection<ClusterOperationInfo.Builder> getClusterOperationInfoList() {
            if (this.clusterOperationInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusterOperationInfoList != null ? (Collection)this.clusterOperationInfoList.stream().map(ClusterOperationInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterOperationInfoList(Collection<ClusterOperationInfo> clusterOperationInfoList) {
            this.clusterOperationInfoList = ___listOfClusterOperationInfoCopier.copy(clusterOperationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterOperationInfoList(ClusterOperationInfo ... clusterOperationInfoList) {
            this.clusterOperationInfoList(Arrays.asList(clusterOperationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterOperationInfoList(Consumer<ClusterOperationInfo.Builder> ... clusterOperationInfoList) {
            this.clusterOperationInfoList(Stream.of(clusterOperationInfoList).map(c -> (ClusterOperationInfo)((ClusterOperationInfo.Builder)ClusterOperationInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterOperationInfoList(Collection<ClusterOperationInfo.BuilderImpl> clusterOperationInfoList) {
            this.clusterOperationInfoList = ___listOfClusterOperationInfoCopier.copyFromBuilder(clusterOperationInfoList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClusterOperationsResponse build() {
            return new ListClusterOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClusterOperationsResponse> {
        public Builder clusterOperationInfoList(Collection<ClusterOperationInfo> var1);

        public Builder clusterOperationInfoList(ClusterOperationInfo ... var1);

        public Builder clusterOperationInfoList(Consumer<ClusterOperationInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

