/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivs.model.ChannelLatencyMode;
import software.amazon.awssdk.services.ivs.model.ChannelType;
import software.amazon.awssdk.services.ivs.model.IvsRequest;
import software.amazon.awssdk.services.ivs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelRequest
extends IvsRequest
implements ToCopyableBuilder<Builder, CreateChannelRequest> {
    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("authorized").getter(CreateChannelRequest.getter(CreateChannelRequest::authorized)).setter(CreateChannelRequest.setter(Builder::authorized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()}).build();
    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latencyMode").getter(CreateChannelRequest.getter(CreateChannelRequest::latencyModeAsString)).setter(CreateChannelRequest.setter(Builder::latencyMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateChannelRequest.getter(CreateChannelRequest::name)).setter(CreateChannelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RECORDING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingConfigurationArn").getter(CreateChannelRequest.getter(CreateChannelRequest::recordingConfigurationArn)).setter(CreateChannelRequest.setter(Builder::recordingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurationArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateChannelRequest.getter(CreateChannelRequest::tags)).setter(CreateChannelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateChannelRequest.getter(CreateChannelRequest::typeAsString)).setter(CreateChannelRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_FIELD, LATENCY_MODE_FIELD, NAME_FIELD, RECORDING_CONFIGURATION_ARN_FIELD, TAGS_FIELD, TYPE_FIELD));
    private final Boolean authorized;
    private final String latencyMode;
    private final String name;
    private final String recordingConfigurationArn;
    private final Map<String, String> tags;
    private final String type;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.authorized = builder.authorized;
        this.latencyMode = builder.latencyMode;
        this.name = builder.name;
        this.recordingConfigurationArn = builder.recordingConfigurationArn;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final Boolean authorized() {
        return this.authorized;
    }

    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(this.latencyMode);
    }

    public final String latencyModeAsString() {
        return this.latencyMode;
    }

    public final String name() {
        return this.name;
    }

    public final String recordingConfigurationArn() {
        return this.recordingConfigurationArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ChannelType type() {
        return ChannelType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorized());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)((Object)obj);
        return Objects.equals(this.authorized(), other.authorized()) && Objects.equals(this.latencyModeAsString(), other.latencyModeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recordingConfigurationArn(), other.recordingConfigurationArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelRequest").add("Authorized", (Object)this.authorized()).add("LatencyMode", (Object)this.latencyModeAsString()).add("Name", (Object)this.name()).add("RecordingConfigurationArn", (Object)this.recordingConfigurationArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorized": {
                return Optional.ofNullable(clazz.cast(this.authorized()));
            }
            case "latencyMode": {
                return Optional.ofNullable(clazz.cast(this.latencyModeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recordingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.recordingConfigurationArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRequest.BuilderImpl
    implements Builder {
        private Boolean authorized;
        private String latencyMode;
        private String name;
        private String recordingConfigurationArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            this.authorized(model.authorized);
            this.latencyMode(model.latencyMode);
            this.name(model.name);
            this.recordingConfigurationArn(model.recordingConfigurationArn);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final Boolean getAuthorized() {
            return this.authorized;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final String getLatencyMode() {
            return this.latencyMode;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecordingConfigurationArn() {
            return this.recordingConfigurationArn;
        }

        public final void setRecordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
        }

        @Override
        public final Builder recordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelRequest> {
        public Builder authorized(Boolean var1);

        public Builder latencyMode(String var1);

        public Builder latencyMode(ChannelLatencyMode var1);

        public Builder name(String var1);

        public Builder recordingConfigurationArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(ChannelType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

