/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse;

public class ListSyncResourcesPublisher
implements SdkPublisher<ListSyncResourcesResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final ListSyncResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSyncResourcesPublisher(IoTTwinMakerAsyncClient client, ListSyncResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSyncResourcesPublisher(IoTTwinMakerAsyncClient client, ListSyncResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSyncResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSyncResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSyncResourcesResponseFetcher
    implements AsyncPageFetcher<ListSyncResourcesResponse> {
        private ListSyncResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListSyncResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSyncResourcesResponse> nextPage(ListSyncResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListSyncResourcesPublisher.this.client.listSyncResources(ListSyncResourcesPublisher.this.firstRequest);
            }
            return ListSyncResourcesPublisher.this.client.listSyncResources((ListSyncResourcesRequest)((Object)ListSyncResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

