/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentsMapCopier;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEntityResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetEntityResponse> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(GetEntityResponse.getter(GetEntityResponse::entityId)).setter(GetEntityResponse.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityName").getter(GetEntityResponse.getter(GetEntityResponse::entityName)).setter(GetEntityResponse.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetEntityResponse.getter(GetEntityResponse::arn)).setter(GetEntityResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Status> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(GetEntityResponse.getter(GetEntityResponse::status)).setter(GetEntityResponse.setter(Builder::status)).constructor(Status::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(GetEntityResponse.getter(GetEntityResponse::workspaceId)).setter(GetEntityResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetEntityResponse.getter(GetEntityResponse::description)).setter(GetEntityResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, ComponentResponse>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("components").getter(GetEntityResponse.getter(GetEntityResponse::components)).setter(GetEntityResponse.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentEntityId").getter(GetEntityResponse.getter(GetEntityResponse::parentEntityId)).setter(GetEntityResponse.setter(Builder::parentEntityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()}).build();
    private static final SdkField<Boolean> HAS_CHILD_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasChildEntities").getter(GetEntityResponse.getter(GetEntityResponse::hasChildEntities)).setter(GetEntityResponse.setter(Builder::hasChildEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasChildEntities").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(GetEntityResponse.getter(GetEntityResponse::creationDateTime)).setter(GetEntityResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(GetEntityResponse.getter(GetEntityResponse::updateDateTime)).setter(GetEntityResponse.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSource").getter(GetEntityResponse.getter(GetEntityResponse::syncSource)).setter(GetEntityResponse.setter(Builder::syncSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, ENTITY_NAME_FIELD, ARN_FIELD, STATUS_FIELD, WORKSPACE_ID_FIELD, DESCRIPTION_FIELD, COMPONENTS_FIELD, PARENT_ENTITY_ID_FIELD, HAS_CHILD_ENTITIES_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD, SYNC_SOURCE_FIELD));
    private final String entityId;
    private final String entityName;
    private final String arn;
    private final Status status;
    private final String workspaceId;
    private final String description;
    private final Map<String, ComponentResponse> components;
    private final String parentEntityId;
    private final Boolean hasChildEntities;
    private final Instant creationDateTime;
    private final Instant updateDateTime;
    private final String syncSource;

    private GetEntityResponse(BuilderImpl builder) {
        super(builder);
        this.entityId = builder.entityId;
        this.entityName = builder.entityName;
        this.arn = builder.arn;
        this.status = builder.status;
        this.workspaceId = builder.workspaceId;
        this.description = builder.description;
        this.components = builder.components;
        this.parentEntityId = builder.parentEntityId;
        this.hasChildEntities = builder.hasChildEntities;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
        this.syncSource = builder.syncSource;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final String arn() {
        return this.arn;
    }

    public final Status status() {
        return this.status;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentResponse> components() {
        return this.components;
    }

    public final String parentEntityId() {
        return this.parentEntityId;
    }

    public final Boolean hasChildEntities() {
        return this.hasChildEntities;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public final String syncSource() {
        return this.syncSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parentEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildEntities());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntityResponse)) {
            return false;
        }
        GetEntityResponse other = (GetEntityResponse)((Object)obj);
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityName(), other.entityName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.description(), other.description()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && Objects.equals(this.parentEntityId(), other.parentEntityId()) && Objects.equals(this.hasChildEntities(), other.hasChildEntities()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.syncSource(), other.syncSource());
    }

    public final String toString() {
        return ToString.builder((String)"GetEntityResponse").add("EntityId", (Object)this.entityId()).add("EntityName", (Object)this.entityName()).add("Arn", (Object)this.arn()).add("Status", (Object)this.status()).add("WorkspaceId", (Object)this.workspaceId()).add("Description", (Object)this.description()).add("Components", this.hasComponents() ? this.components() : null).add("ParentEntityId", (Object)this.parentEntityId()).add("HasChildEntities", (Object)this.hasChildEntities()).add("CreationDateTime", (Object)this.creationDateTime()).add("UpdateDateTime", (Object)this.updateDateTime()).add("SyncSource", (Object)this.syncSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "parentEntityId": {
                return Optional.ofNullable(clazz.cast(this.parentEntityId()));
            }
            case "hasChildEntities": {
                return Optional.ofNullable(clazz.cast(this.hasChildEntities()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "syncSource": {
                return Optional.ofNullable(clazz.cast(this.syncSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEntityResponse, T> g) {
        return obj -> g.apply((GetEntityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String entityId;
        private String entityName;
        private String arn;
        private Status status;
        private String workspaceId;
        private String description;
        private Map<String, ComponentResponse> components = DefaultSdkAutoConstructMap.getInstance();
        private String parentEntityId;
        private Boolean hasChildEntities;
        private Instant creationDateTime;
        private Instant updateDateTime;
        private String syncSource;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntityResponse model) {
            super(model);
            this.entityId(model.entityId);
            this.entityName(model.entityName);
            this.arn(model.arn);
            this.status(model.status);
            this.workspaceId(model.workspaceId);
            this.description(model.description);
            this.components(model.components);
            this.parentEntityId(model.parentEntityId);
            this.hasChildEntities(model.hasChildEntities);
            this.creationDateTime(model.creationDateTime);
            this.updateDateTime(model.updateDateTime);
            this.syncSource(model.syncSource);
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Status.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, ComponentResponse.Builder> getComponents() {
            Map<String, ComponentResponse.Builder> result = ComponentsMapCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponents(Map<String, ComponentResponse.BuilderImpl> components) {
            this.components = ComponentsMapCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Map<String, ComponentResponse> components) {
            this.components = ComponentsMapCopier.copy(components);
            return this;
        }

        public final String getParentEntityId() {
            return this.parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        public final Boolean getHasChildEntities() {
            return this.hasChildEntities;
        }

        public final void setHasChildEntities(Boolean hasChildEntities) {
            this.hasChildEntities = hasChildEntities;
        }

        @Override
        public final Builder hasChildEntities(Boolean hasChildEntities) {
            this.hasChildEntities = hasChildEntities;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getSyncSource() {
            return this.syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        @Override
        public GetEntityResponse build() {
            return new GetEntityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEntityResponse> {
        public Builder entityId(String var1);

        public Builder entityName(String var1);

        public Builder arn(String var1);

        public Builder status(Status var1);

        default public Builder status(Consumer<Status.Builder> status) {
            return this.status((Status)((Status.Builder)Status.builder().applyMutation(status)).build());
        }

        public Builder workspaceId(String var1);

        public Builder description(String var1);

        public Builder components(Map<String, ComponentResponse> var1);

        public Builder parentEntityId(String var1);

        public Builder hasChildEntities(Boolean var1);

        public Builder creationDateTime(Instant var1);

        public Builder updateDateTime(Instant var1);

        public Builder syncSource(String var1);
    }
}

