/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The function response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionResponse.Builder, FunctionResponse> {
    private static final SdkField<List<String>> REQUIRED_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("requiredProperties")
            .getter(getter(FunctionResponse::requiredProperties))
            .setter(setter(Builder::requiredProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(FunctionResponse::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<DataConnector> IMPLEMENTED_BY_FIELD = SdkField
            .<DataConnector> builder(MarshallingType.SDK_POJO).memberName("implementedBy")
            .getter(getter(FunctionResponse::implementedBy)).setter(setter(Builder::implementedBy))
            .constructor(DataConnector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("implementedBy").build()).build();

    private static final SdkField<Boolean> IS_INHERITED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isInherited").getter(getter(FunctionResponse::isInherited)).setter(setter(Builder::isInherited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isInherited").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRED_PROPERTIES_FIELD,
            SCOPE_FIELD, IMPLEMENTED_BY_FIELD, IS_INHERITED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> requiredProperties;

    private final String scope;

    private final DataConnector implementedBy;

    private final Boolean isInherited;

    private FunctionResponse(BuilderImpl builder) {
        this.requiredProperties = builder.requiredProperties;
        this.scope = builder.scope;
        this.implementedBy = builder.implementedBy;
        this.isInherited = builder.isInherited;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequiredProperties() {
        return requiredProperties != null && !(requiredProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The required properties of the function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredProperties} method.
     * </p>
     * 
     * @return The required properties of the function.
     */
    public final List<String> requiredProperties() {
        return requiredProperties;
    }

    /**
     * <p>
     * The scope of the function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the function.
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of the function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the function.
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The data connector.
     * </p>
     * 
     * @return The data connector.
     */
    public final DataConnector implementedBy() {
        return implementedBy;
    }

    /**
     * <p>
     * Indicates whether this function is inherited.
     * </p>
     * 
     * @return Indicates whether this function is inherited.
     */
    public final Boolean isInherited() {
        return isInherited;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiredProperties() ? requiredProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(implementedBy());
        hashCode = 31 * hashCode + Objects.hashCode(isInherited());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionResponse)) {
            return false;
        }
        FunctionResponse other = (FunctionResponse) obj;
        return hasRequiredProperties() == other.hasRequiredProperties()
                && Objects.equals(requiredProperties(), other.requiredProperties())
                && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(implementedBy(), other.implementedBy()) && Objects.equals(isInherited(), other.isInherited());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionResponse")
                .add("RequiredProperties", hasRequiredProperties() ? requiredProperties() : null).add("Scope", scopeAsString())
                .add("ImplementedBy", implementedBy()).add("IsInherited", isInherited()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requiredProperties":
            return Optional.ofNullable(clazz.cast(requiredProperties()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "implementedBy":
            return Optional.ofNullable(clazz.cast(implementedBy()));
        case "isInherited":
            return Optional.ofNullable(clazz.cast(isInherited()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionResponse, T> g) {
        return obj -> g.apply((FunctionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionResponse> {
        /**
         * <p>
         * The required properties of the function.
         * </p>
         * 
         * @param requiredProperties
         *        The required properties of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredProperties(Collection<String> requiredProperties);

        /**
         * <p>
         * The required properties of the function.
         * </p>
         * 
         * @param requiredProperties
         *        The required properties of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredProperties(String... requiredProperties);

        /**
         * <p>
         * The scope of the function.
         * </p>
         * 
         * @param scope
         *        The scope of the function.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of the function.
         * </p>
         * 
         * @param scope
         *        The scope of the function.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * The data connector.
         * </p>
         * 
         * @param implementedBy
         *        The data connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder implementedBy(DataConnector implementedBy);

        /**
         * <p>
         * The data connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataConnector.Builder} avoiding the need
         * to create one manually via {@link DataConnector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataConnector.Builder#build()} is called immediately and its
         * result is passed to {@link #implementedBy(DataConnector)}.
         * 
         * @param implementedBy
         *        a consumer that will call methods on {@link DataConnector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #implementedBy(DataConnector)
         */
        default Builder implementedBy(Consumer<DataConnector.Builder> implementedBy) {
            return implementedBy(DataConnector.builder().applyMutation(implementedBy).build());
        }

        /**
         * <p>
         * Indicates whether this function is inherited.
         * </p>
         * 
         * @param isInherited
         *        Indicates whether this function is inherited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isInherited(Boolean isInherited);
    }

    static final class BuilderImpl implements Builder {
        private List<String> requiredProperties = DefaultSdkAutoConstructList.getInstance();

        private String scope;

        private DataConnector implementedBy;

        private Boolean isInherited;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionResponse model) {
            requiredProperties(model.requiredProperties);
            scope(model.scope);
            implementedBy(model.implementedBy);
            isInherited(model.isInherited);
        }

        public final Collection<String> getRequiredProperties() {
            if (requiredProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return requiredProperties;
        }

        public final void setRequiredProperties(Collection<String> requiredProperties) {
            this.requiredProperties = RequiredPropertiesCopier.copy(requiredProperties);
        }

        @Override
        public final Builder requiredProperties(Collection<String> requiredProperties) {
            this.requiredProperties = RequiredPropertiesCopier.copy(requiredProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredProperties(String... requiredProperties) {
            requiredProperties(Arrays.asList(requiredProperties));
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final DataConnector.Builder getImplementedBy() {
            return implementedBy != null ? implementedBy.toBuilder() : null;
        }

        public final void setImplementedBy(DataConnector.BuilderImpl implementedBy) {
            this.implementedBy = implementedBy != null ? implementedBy.build() : null;
        }

        @Override
        public final Builder implementedBy(DataConnector implementedBy) {
            this.implementedBy = implementedBy;
            return this;
        }

        public final Boolean getIsInherited() {
            return isInherited;
        }

        public final void setIsInherited(Boolean isInherited) {
            this.isInherited = isInherited;
        }

        @Override
        public final Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            return this;
        }

        @Override
        public FunctionResponse build() {
            return new FunctionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
