/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteQueryResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<ExecuteQueryResponse.Builder, ExecuteQueryResponse> {
    private static final SdkField<List<ColumnDescription>> COLUMN_DESCRIPTIONS_FIELD = SdkField
            .<List<ColumnDescription>> builder(MarshallingType.LIST)
            .memberName("columnDescriptions")
            .getter(getter(ExecuteQueryResponse::columnDescriptions))
            .setter(setter(Builder::columnDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Row>> ROWS_FIELD = SdkField
            .<List<Row>> builder(MarshallingType.LIST)
            .memberName("rows")
            .getter(getter(ExecuteQueryResponse::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Row> builder(MarshallingType.SDK_POJO)
                                            .constructor(Row::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ExecuteQueryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_DESCRIPTIONS_FIELD,
            ROWS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ColumnDescription> columnDescriptions;

    private final List<Row> rows;

    private final String nextToken;

    private ExecuteQueryResponse(BuilderImpl builder) {
        super(builder);
        this.columnDescriptions = builder.columnDescriptions;
        this.rows = builder.rows;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnDescriptions() {
        return columnDescriptions != null && !(columnDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ColumnDescription objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnDescriptions} method.
     * </p>
     * 
     * @return A list of ColumnDescription objects.
     */
    public final List<ColumnDescription> columnDescriptions() {
        return columnDescriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a single row in the query results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRows} method.
     * </p>
     * 
     * @return Represents a single row in the query results.
     */
    public final List<Row> rows() {
        return rows;
    }

    /**
     * <p>
     * The string that specifies the next page of results.
     * </p>
     * 
     * @return The string that specifies the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnDescriptions() ? columnDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteQueryResponse)) {
            return false;
        }
        ExecuteQueryResponse other = (ExecuteQueryResponse) obj;
        return hasColumnDescriptions() == other.hasColumnDescriptions()
                && Objects.equals(columnDescriptions(), other.columnDescriptions()) && hasRows() == other.hasRows()
                && Objects.equals(rows(), other.rows()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteQueryResponse")
                .add("ColumnDescriptions", hasColumnDescriptions() ? columnDescriptions() : null)
                .add("Rows", hasRows() ? rows() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnDescriptions":
            return Optional.ofNullable(clazz.cast(columnDescriptions()));
        case "rows":
            return Optional.ofNullable(clazz.cast(rows()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteQueryResponse, T> g) {
        return obj -> g.apply((ExecuteQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteQueryResponse> {
        /**
         * <p>
         * A list of ColumnDescription objects.
         * </p>
         * 
         * @param columnDescriptions
         *        A list of ColumnDescription objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnDescriptions(Collection<ColumnDescription> columnDescriptions);

        /**
         * <p>
         * A list of ColumnDescription objects.
         * </p>
         * 
         * @param columnDescriptions
         *        A list of ColumnDescription objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnDescriptions(ColumnDescription... columnDescriptions);

        /**
         * <p>
         * A list of ColumnDescription objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.ColumnDescription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iottwinmaker.model.ColumnDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.ColumnDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #columnDescriptions(List<ColumnDescription>)}.
         * 
         * @param columnDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.ColumnDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnDescriptions(java.util.Collection<ColumnDescription>)
         */
        Builder columnDescriptions(Consumer<ColumnDescription.Builder>... columnDescriptions);

        /**
         * <p>
         * Represents a single row in the query results.
         * </p>
         * 
         * @param rows
         *        Represents a single row in the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<Row> rows);

        /**
         * <p>
         * Represents a single row in the query results.
         * </p>
         * 
         * @param rows
         *        Represents a single row in the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Row... rows);

        /**
         * <p>
         * Represents a single row in the query results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.Row.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iottwinmaker.model.Row#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.Row.Builder#build()} is called immediately and its
         * result is passed to {@link #rows(List<Row>)}.
         * 
         * @param rows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.Row.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(java.util.Collection<Row>)
         */
        Builder rows(Consumer<Row.Builder>... rows);

        /**
         * <p>
         * The string that specifies the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private List<ColumnDescription> columnDescriptions = DefaultSdkAutoConstructList.getInstance();

        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteQueryResponse model) {
            super(model);
            columnDescriptions(model.columnDescriptions);
            rows(model.rows);
            nextToken(model.nextToken);
        }

        public final List<ColumnDescription.Builder> getColumnDescriptions() {
            List<ColumnDescription.Builder> result = ColumnDescriptionsCopier.copyToBuilder(this.columnDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnDescriptions(Collection<ColumnDescription.BuilderImpl> columnDescriptions) {
            this.columnDescriptions = ColumnDescriptionsCopier.copyFromBuilder(columnDescriptions);
        }

        @Override
        public final Builder columnDescriptions(Collection<ColumnDescription> columnDescriptions) {
            this.columnDescriptions = ColumnDescriptionsCopier.copy(columnDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnDescriptions(ColumnDescription... columnDescriptions) {
            columnDescriptions(Arrays.asList(columnDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnDescriptions(Consumer<ColumnDescription.Builder>... columnDescriptions) {
            columnDescriptions(Stream.of(columnDescriptions).map(c -> ColumnDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Row.Builder> getRows() {
            List<Row.Builder> result = RowsCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowsCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowsCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder>... rows) {
            rows(Stream.of(rows).map(c -> Row.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ExecuteQueryResponse build() {
            return new ExecuteQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
