/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the (pre-calculated) aggregate values for an asset property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Aggregates implements SdkPojo, Serializable, ToCopyableBuilder<Aggregates.Builder, Aggregates> {
    private static final SdkField<Double> AVERAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("average")
            .getter(getter(Aggregates::average)).setter(setter(Builder::average))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("average").build()).build();

    private static final SdkField<Double> COUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("count")
            .getter(getter(Aggregates::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("maximum")
            .getter(getter(Aggregates::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximum").build()).build();

    private static final SdkField<Double> MINIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("minimum")
            .getter(getter(Aggregates::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimum").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("sum")
            .getter(getter(Aggregates::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sum").build()).build();

    private static final SdkField<Double> STANDARD_DEVIATION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("standardDeviation").getter(getter(Aggregates::standardDeviation))
            .setter(setter(Builder::standardDeviation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardDeviation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVERAGE_FIELD, COUNT_FIELD,
            MAXIMUM_FIELD, MINIMUM_FIELD, SUM_FIELD, STANDARD_DEVIATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double average;

    private final Double count;

    private final Double maximum;

    private final Double minimum;

    private final Double sum;

    private final Double standardDeviation;

    private Aggregates(BuilderImpl builder) {
        this.average = builder.average;
        this.count = builder.count;
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.sum = builder.sum;
        this.standardDeviation = builder.standardDeviation;
    }

    /**
     * <p>
     * The average (mean) value of the time series over a time interval window.
     * </p>
     * 
     * @return The average (mean) value of the time series over a time interval window.
     */
    public final Double average() {
        return average;
    }

    /**
     * <p>
     * The count of data points in the time series over a time interval window.
     * </p>
     * 
     * @return The count of data points in the time series over a time interval window.
     */
    public final Double count() {
        return count;
    }

    /**
     * <p>
     * The maximum value of the time series over a time interval window.
     * </p>
     * 
     * @return The maximum value of the time series over a time interval window.
     */
    public final Double maximum() {
        return maximum;
    }

    /**
     * <p>
     * The minimum value of the time series over a time interval window.
     * </p>
     * 
     * @return The minimum value of the time series over a time interval window.
     */
    public final Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The sum of the time series over a time interval window.
     * </p>
     * 
     * @return The sum of the time series over a time interval window.
     */
    public final Double sum() {
        return sum;
    }

    /**
     * <p>
     * The standard deviation of the time series over a time interval window.
     * </p>
     * 
     * @return The standard deviation of the time series over a time interval window.
     */
    public final Double standardDeviation() {
        return standardDeviation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(average());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        hashCode = 31 * hashCode + Objects.hashCode(standardDeviation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Aggregates)) {
            return false;
        }
        Aggregates other = (Aggregates) obj;
        return Objects.equals(average(), other.average()) && Objects.equals(count(), other.count())
                && Objects.equals(maximum(), other.maximum()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(sum(), other.sum()) && Objects.equals(standardDeviation(), other.standardDeviation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Aggregates").add("Average", average()).add("Count", count()).add("Maximum", maximum())
                .add("Minimum", minimum()).add("Sum", sum()).add("StandardDeviation", standardDeviation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "average":
            return Optional.ofNullable(clazz.cast(average()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "sum":
            return Optional.ofNullable(clazz.cast(sum()));
        case "standardDeviation":
            return Optional.ofNullable(clazz.cast(standardDeviation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Aggregates, T> g) {
        return obj -> g.apply((Aggregates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Aggregates> {
        /**
         * <p>
         * The average (mean) value of the time series over a time interval window.
         * </p>
         * 
         * @param average
         *        The average (mean) value of the time series over a time interval window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder average(Double average);

        /**
         * <p>
         * The count of data points in the time series over a time interval window.
         * </p>
         * 
         * @param count
         *        The count of data points in the time series over a time interval window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Double count);

        /**
         * <p>
         * The maximum value of the time series over a time interval window.
         * </p>
         * 
         * @param maximum
         *        The maximum value of the time series over a time interval window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);

        /**
         * <p>
         * The minimum value of the time series over a time interval window.
         * </p>
         * 
         * @param minimum
         *        The minimum value of the time series over a time interval window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The sum of the time series over a time interval window.
         * </p>
         * 
         * @param sum
         *        The sum of the time series over a time interval window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The standard deviation of the time series over a time interval window.
         * </p>
         * 
         * @param standardDeviation
         *        The standard deviation of the time series over a time interval window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardDeviation(Double standardDeviation);
    }

    static final class BuilderImpl implements Builder {
        private Double average;

        private Double count;

        private Double maximum;

        private Double minimum;

        private Double sum;

        private Double standardDeviation;

        private BuilderImpl() {
        }

        private BuilderImpl(Aggregates model) {
            average(model.average);
            count(model.count);
            maximum(model.maximum);
            minimum(model.minimum);
            sum(model.sum);
            standardDeviation(model.standardDeviation);
        }

        public final Double getAverage() {
            return average;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final Double getCount() {
            return count;
        }

        public final void setCount(Double count) {
            this.count = count;
        }

        @Override
        public final Builder count(Double count) {
            this.count = count;
            return this;
        }

        public final Double getMaximum() {
            return maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Double getMinimum() {
            return minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Double getSum() {
            return sum;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final Double getStandardDeviation() {
            return standardDeviation;
        }

        public final void setStandardDeviation(Double standardDeviation) {
            this.standardDeviation = standardDeviation;
        }

        @Override
        public final Builder standardDeviation(Double standardDeviation) {
            this.standardDeviation = standardDeviation;
            return this;
        }

        @Override
        public Aggregates build() {
            return new Aggregates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
