/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerClient;
import software.amazon.awssdk.services.iotroborunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse;
import software.amazon.awssdk.services.iotroborunner.model.Worker;

public class ListWorkersIterable
implements SdkIterable<ListWorkersResponse> {
    private final IotRoboRunnerClient client;
    private final ListWorkersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkersIterable(IotRoboRunnerClient client, ListWorkersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkersResponseFetcher();
    }

    public Iterator<ListWorkersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Worker> workers() {
        Function<ListWorkersResponse, Iterator> getIterator = response -> {
            if (response != null && response.workers() != null) {
                return response.workers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkersResponseFetcher
    implements SyncPageFetcher<ListWorkersResponse> {
        private ListWorkersResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkersResponse nextPage(ListWorkersResponse previousPage) {
            if (previousPage == null) {
                return ListWorkersIterable.this.client.listWorkers(ListWorkersIterable.this.firstRequest);
            }
            return ListWorkersIterable.this.client.listWorkers((ListWorkersRequest)((Object)ListWorkersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

