/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotroborunner.DefaultIotRoboRunnerBaseClientBuilder;
import software.amazon.awssdk.services.iotroborunner.DefaultIotRoboRunnerClient;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerClient;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerClientBuilder;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerServiceClientConfiguration;
import software.amazon.awssdk.services.iotroborunner.endpoints.IotRoboRunnerEndpointProvider;

@SdkInternalApi
final class DefaultIotRoboRunnerClientBuilder
extends DefaultIotRoboRunnerBaseClientBuilder<IotRoboRunnerClientBuilder, IotRoboRunnerClient>
implements IotRoboRunnerClientBuilder {
    DefaultIotRoboRunnerClientBuilder() {
    }

    @Override
    public DefaultIotRoboRunnerClientBuilder endpointProvider(IotRoboRunnerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotRoboRunnerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIotRoboRunnerClientBuilder.validateClientOptions(clientConfiguration);
        IotRoboRunnerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotRoboRunnerClient client = new DefaultIotRoboRunnerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotRoboRunnerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotRoboRunnerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

