/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotroborunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDestinationsRequest extends IotRoboRunnerRequest implements
        ToCopyableBuilder<ListDestinationsRequest.Builder, ListDestinationsRequest> {
    private static final SdkField<String> SITE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("site")
            .getter(getter(ListDestinationsRequest::site)).setter(setter(Builder::site))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("site").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDestinationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDestinationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ListDestinationsRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, STATE_FIELD));

    private final String site;

    private final Integer maxResults;

    private final String nextToken;

    private final String state;

    private ListDestinationsRequest(BuilderImpl builder) {
        super(builder);
        this.site = builder.site;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.state = builder.state;
    }

    /**
     * Returns the value of the Site property for this object.
     * 
     * @return The value of the Site property for this object.
     */
    public final String site() {
        return site;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DestinationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see DestinationState
     */
    public final DestinationState state() {
        return DestinationState.fromValue(state);
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DestinationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see DestinationState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(site());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDestinationsRequest)) {
            return false;
        }
        ListDestinationsRequest other = (ListDestinationsRequest) obj;
        return Objects.equals(site(), other.site()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDestinationsRequest").add("Site", site()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "site":
            return Optional.ofNullable(clazz.cast(site()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDestinationsRequest, T> g) {
        return obj -> g.apply((ListDestinationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRoboRunnerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDestinationsRequest> {
        /**
         * Sets the value of the Site property for this object.
         *
         * @param site
         *        The new value for the Site property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder site(String site);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see DestinationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationState
         */
        Builder state(String state);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see DestinationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationState
         */
        Builder state(DestinationState state);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRoboRunnerRequest.BuilderImpl implements Builder {
        private String site;

        private Integer maxResults;

        private String nextToken;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDestinationsRequest model) {
            super(model);
            site(model.site);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            state(model.state);
        }

        public final String getSite() {
            return site;
        }

        public final void setSite(String site) {
            this.site = site;
        }

        @Override
        public final Builder site(String site) {
            this.site = site;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DestinationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDestinationsRequest build() {
            return new ListDestinationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
