/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.Node;

public class ListSignalCatalogNodesIterable
implements SdkIterable<ListSignalCatalogNodesResponse> {
    private final IoTFleetWiseClient client;
    private final ListSignalCatalogNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSignalCatalogNodesIterable(IoTFleetWiseClient client, ListSignalCatalogNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSignalCatalogNodesResponseFetcher();
    }

    public Iterator<ListSignalCatalogNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Node> nodes() {
        Function<ListSignalCatalogNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodes() != null) {
                return response.nodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSignalCatalogNodesResponseFetcher
    implements SyncPageFetcher<ListSignalCatalogNodesResponse> {
        private ListSignalCatalogNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListSignalCatalogNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSignalCatalogNodesResponse nextPage(ListSignalCatalogNodesResponse previousPage) {
            if (previousPage == null) {
                return ListSignalCatalogNodesIterable.this.client.listSignalCatalogNodes(ListSignalCatalogNodesIterable.this.firstRequest);
            }
            return ListSignalCatalogNodesIterable.this.client.listSignalCatalogNodes((ListSignalCatalogNodesRequest)((Object)ListSignalCatalogNodesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

