/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request couldn't be completed because it contains signals that aren't valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidSignalsException extends IoTFleetWiseException implements
        ToCopyableBuilder<InvalidSignalsException.Builder, InvalidSignalsException> {
    private static final SdkField<List<InvalidSignal>> INVALID_SIGNALS_FIELD = SdkField
            .<List<InvalidSignal>> builder(MarshallingType.LIST)
            .memberName("invalidSignals")
            .getter(getter(InvalidSignalsException::invalidSignals))
            .setter(setter(Builder::invalidSignals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidSignals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvalidSignal> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvalidSignal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_SIGNALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InvalidSignal> invalidSignals;

    private InvalidSignalsException(BuilderImpl builder) {
        super(builder);
        this.invalidSignals = builder.invalidSignals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvalidSignals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasInvalidSignals() {
        return invalidSignals != null && !(invalidSignals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The signals which caused the exception.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvalidSignals} method.
     * </p>
     * 
     * @return The signals which caused the exception.
     */
    public List<InvalidSignal> invalidSignals() {
        return invalidSignals;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidSignalsException, T> g) {
        return obj -> g.apply((InvalidSignalsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidSignalsException>, IoTFleetWiseException.Builder {
        /**
         * <p>
         * The signals which caused the exception.
         * </p>
         * 
         * @param invalidSignals
         *        The signals which caused the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidSignals(Collection<InvalidSignal> invalidSignals);

        /**
         * <p>
         * The signals which caused the exception.
         * </p>
         * 
         * @param invalidSignals
         *        The signals which caused the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidSignals(InvalidSignal... invalidSignals);

        /**
         * <p>
         * The signals which caused the exception.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidSignal.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidSignal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidSignal.Builder#build()} is called
         * immediately and its result is passed to {@link #invalidSignals(List<InvalidSignal>)}.
         * 
         * @param invalidSignals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotfleetwise.model.InvalidSignal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidSignals(java.util.Collection<InvalidSignal>)
         */
        Builder invalidSignals(Consumer<InvalidSignal.Builder>... invalidSignals);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends IoTFleetWiseException.BuilderImpl implements Builder {
        private List<InvalidSignal> invalidSignals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidSignalsException model) {
            super(model);
            invalidSignals(model.invalidSignals);
        }

        public final List<InvalidSignal.Builder> getInvalidSignals() {
            List<InvalidSignal.Builder> result = InvalidSignalsCopier.copyToBuilder(this.invalidSignals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidSignals(Collection<InvalidSignal.BuilderImpl> invalidSignals) {
            this.invalidSignals = InvalidSignalsCopier.copyFromBuilder(invalidSignals);
        }

        @Override
        public final Builder invalidSignals(Collection<InvalidSignal> invalidSignals) {
            this.invalidSignals = InvalidSignalsCopier.copy(invalidSignals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidSignals(InvalidSignal... invalidSignals) {
            invalidSignals(Arrays.asList(invalidSignals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidSignals(Consumer<InvalidSignal.Builder>... invalidSignals) {
            invalidSignals(Stream.of(invalidSignals).map(c -> InvalidSignal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public InvalidSignalsException build() {
            return new InvalidSignalsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
