/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestSummary;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse;

public class ListDecoderManifestsIterable
implements SdkIterable<ListDecoderManifestsResponse> {
    private final IoTFleetWiseClient client;
    private final ListDecoderManifestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDecoderManifestsIterable(IoTFleetWiseClient client, ListDecoderManifestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDecoderManifestsResponseFetcher();
    }

    public Iterator<ListDecoderManifestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DecoderManifestSummary> summaries() {
        Function<ListDecoderManifestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDecoderManifestsResponseFetcher
    implements SyncPageFetcher<ListDecoderManifestsResponse> {
        private ListDecoderManifestsResponseFetcher() {
        }

        public boolean hasNextPage(ListDecoderManifestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDecoderManifestsResponse nextPage(ListDecoderManifestsResponse previousPage) {
            if (previousPage == null) {
                return ListDecoderManifestsIterable.this.client.listDecoderManifests(ListDecoderManifestsIterable.this.firstRequest);
            }
            return ListDecoderManifestsIterable.this.client.listDecoderManifests((ListDecoderManifestsRequest)((Object)ListDecoderManifestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

